# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from devopso.clients.confluence_cloud.models.create_page200_response import CreatePage200Response
from devopso.clients.confluence_cloud.models.create_page_request import CreatePageRequest
from devopso.clients.confluence_cloud.models.multi_entity_result_page import MultiEntityResultPage
from devopso.clients.confluence_cloud.models.page_sort_order import PageSortOrder
from devopso.clients.confluence_cloud.models.primary_body_representation import PrimaryBodyRepresentation
from devopso.clients.confluence_cloud.models.primary_body_representation_single import PrimaryBodyRepresentationSingle
from devopso.clients.confluence_cloud.models.update_page_request import UpdatePageRequest
from devopso.clients.confluence_cloud.models.update_page_title_request import UpdatePageTitleRequest

from devopso.clients.confluence_cloud.api_client import ApiClient, RequestSerialized
from devopso.clients.confluence_cloud.api_response import ApiResponse
from devopso.clients.confluence_cloud.rest import RESTResponseType


class PageApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_page(
        self,
        create_page_request: CreatePageRequest,
        embedded: Annotated[Optional[StrictBool], Field(description="Tag the content as embedded and content will be created in NCS.")] = None,
        private: Annotated[Optional[StrictBool], Field(description="The page will be private. Only the user who creates this page will have permission to view and edit one.")] = None,
        root_level: Annotated[Optional[StrictBool], Field(description="The page will be created at the root level of the space (outside the space homepage tree). If true, then a  value may not be supplied for the `parentId` body parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePage200Response:
        """Create page

        Creates a page in the space.  Pages are created as published by default unless specified as a draft in the status field. If creating a published page, the title must be specified.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the corresponding space. Permission to create a page in the space.

        :param create_page_request: (required)
        :type create_page_request: CreatePageRequest
        :param embedded: Tag the content as embedded and content will be created in NCS.
        :type embedded: bool
        :param private: The page will be private. Only the user who creates this page will have permission to view and edit one.
        :type private: bool
        :param root_level: The page will be created at the root level of the space (outside the space homepage tree). If true, then a  value may not be supplied for the `parentId` body parameter.
        :type root_level: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_page_serialize(
            create_page_request=create_page_request,
            embedded=embedded,
            private=private,
            root_level=root_level,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_page_with_http_info(
        self,
        create_page_request: CreatePageRequest,
        embedded: Annotated[Optional[StrictBool], Field(description="Tag the content as embedded and content will be created in NCS.")] = None,
        private: Annotated[Optional[StrictBool], Field(description="The page will be private. Only the user who creates this page will have permission to view and edit one.")] = None,
        root_level: Annotated[Optional[StrictBool], Field(description="The page will be created at the root level of the space (outside the space homepage tree). If true, then a  value may not be supplied for the `parentId` body parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePage200Response]:
        """Create page

        Creates a page in the space.  Pages are created as published by default unless specified as a draft in the status field. If creating a published page, the title must be specified.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the corresponding space. Permission to create a page in the space.

        :param create_page_request: (required)
        :type create_page_request: CreatePageRequest
        :param embedded: Tag the content as embedded and content will be created in NCS.
        :type embedded: bool
        :param private: The page will be private. Only the user who creates this page will have permission to view and edit one.
        :type private: bool
        :param root_level: The page will be created at the root level of the space (outside the space homepage tree). If true, then a  value may not be supplied for the `parentId` body parameter.
        :type root_level: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_page_serialize(
            create_page_request=create_page_request,
            embedded=embedded,
            private=private,
            root_level=root_level,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_page_without_preload_content(
        self,
        create_page_request: CreatePageRequest,
        embedded: Annotated[Optional[StrictBool], Field(description="Tag the content as embedded and content will be created in NCS.")] = None,
        private: Annotated[Optional[StrictBool], Field(description="The page will be private. Only the user who creates this page will have permission to view and edit one.")] = None,
        root_level: Annotated[Optional[StrictBool], Field(description="The page will be created at the root level of the space (outside the space homepage tree). If true, then a  value may not be supplied for the `parentId` body parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create page

        Creates a page in the space.  Pages are created as published by default unless specified as a draft in the status field. If creating a published page, the title must be specified.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the corresponding space. Permission to create a page in the space.

        :param create_page_request: (required)
        :type create_page_request: CreatePageRequest
        :param embedded: Tag the content as embedded and content will be created in NCS.
        :type embedded: bool
        :param private: The page will be private. Only the user who creates this page will have permission to view and edit one.
        :type private: bool
        :param root_level: The page will be created at the root level of the space (outside the space homepage tree). If true, then a  value may not be supplied for the `parentId` body parameter.
        :type root_level: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_page_serialize(
            create_page_request=create_page_request,
            embedded=embedded,
            private=private,
            root_level=root_level,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_page_serialize(
        self,
        create_page_request,
        embedded,
        private,
        root_level,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if embedded is not None:
            
            _query_params.append(('embedded', embedded))
            
        if private is not None:
            
            _query_params.append(('private', private))
            
        if root_level is not None:
            
            _query_params.append(('root-level', root_level))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_page_request is not None:
            _body_params = create_page_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/pages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_page(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be deleted.")],
        purge: Annotated[Optional[StrictBool], Field(description="If attempting to purge the page.")] = None,
        draft: Annotated[Optional[StrictBool], Field(description="If attempting to delete a page that is a draft.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete page

        Delete a page by id.  By default this will delete pages that are non-drafts. To delete a page that is a draft, the endpoint must be called on a  draft with the following param `draft=true`. Discarded drafts are not sent to the trash and are permanently deleted.  Deleting a page moves the page to the trash, where it can be restored later. To permanently delete a page (or \"purge\" it), the endpoint must be called on a **trashed** page with the following param `purge=true`.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to delete pages in the space. Permission to administer the space (if attempting to purge).

        :param id: The ID of the page to be deleted. (required)
        :type id: int
        :param purge: If attempting to purge the page.
        :type purge: bool
        :param draft: If attempting to delete a page that is a draft.
        :type draft: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_page_serialize(
            id=id,
            purge=purge,
            draft=draft,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_page_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be deleted.")],
        purge: Annotated[Optional[StrictBool], Field(description="If attempting to purge the page.")] = None,
        draft: Annotated[Optional[StrictBool], Field(description="If attempting to delete a page that is a draft.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete page

        Delete a page by id.  By default this will delete pages that are non-drafts. To delete a page that is a draft, the endpoint must be called on a  draft with the following param `draft=true`. Discarded drafts are not sent to the trash and are permanently deleted.  Deleting a page moves the page to the trash, where it can be restored later. To permanently delete a page (or \"purge\" it), the endpoint must be called on a **trashed** page with the following param `purge=true`.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to delete pages in the space. Permission to administer the space (if attempting to purge).

        :param id: The ID of the page to be deleted. (required)
        :type id: int
        :param purge: If attempting to purge the page.
        :type purge: bool
        :param draft: If attempting to delete a page that is a draft.
        :type draft: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_page_serialize(
            id=id,
            purge=purge,
            draft=draft,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_page_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be deleted.")],
        purge: Annotated[Optional[StrictBool], Field(description="If attempting to purge the page.")] = None,
        draft: Annotated[Optional[StrictBool], Field(description="If attempting to delete a page that is a draft.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete page

        Delete a page by id.  By default this will delete pages that are non-drafts. To delete a page that is a draft, the endpoint must be called on a  draft with the following param `draft=true`. Discarded drafts are not sent to the trash and are permanently deleted.  Deleting a page moves the page to the trash, where it can be restored later. To permanently delete a page (or \"purge\" it), the endpoint must be called on a **trashed** page with the following param `purge=true`.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to delete pages in the space. Permission to administer the space (if attempting to purge).

        :param id: The ID of the page to be deleted. (required)
        :type id: int
        :param purge: If attempting to purge the page.
        :type purge: bool
        :param draft: If attempting to delete a page that is a draft.
        :type draft: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_page_serialize(
            id=id,
            purge=purge,
            draft=draft,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_page_serialize(
        self,
        id,
        purge,
        draft,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if purge is not None:
            
            _query_params.append(('purge', purge))
            
        if draft is not None:
            
            _query_params.append(('draft', draft))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/pages/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_label_pages(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the label for which pages should be returned.")],
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MultiEntityResultPage:
        """Get pages for label

        Returns the pages of specified label. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the content of the page and its corresponding space.

        :param id: The ID of the label for which pages should be returned. (required)
        :type id: int
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_label_pages_serialize(
            id=id,
            space_id=space_id,
            body_format=body_format,
            sort=sort,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_label_pages_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the label for which pages should be returned.")],
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MultiEntityResultPage]:
        """Get pages for label

        Returns the pages of specified label. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the content of the page and its corresponding space.

        :param id: The ID of the label for which pages should be returned. (required)
        :type id: int
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_label_pages_serialize(
            id=id,
            space_id=space_id,
            body_format=body_format,
            sort=sort,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_label_pages_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the label for which pages should be returned.")],
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get pages for label

        Returns the pages of specified label. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the content of the page and its corresponding space.

        :param id: The ID of the label for which pages should be returned. (required)
        :type id: int
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_label_pages_serialize(
            id=id,
            space_id=space_id,
            body_format=body_format,
            sort=sort,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_label_pages_serialize(
        self,
        id,
        space_id,
        body_format,
        sort,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'space-id': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if space_id is not None:
            
            _query_params.append(('space-id', space_id))
            
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/labels/{id}/pages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_page_by_id(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be returned. If you don't know the page ID, use Get pages and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentationSingle], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        get_draft: Annotated[Optional[StrictBool], Field(description="Retrieve the draft version of this page.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the page being retrieved by its status.")] = None,
        version: Annotated[Optional[StrictInt], Field(description="Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes content properties associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this page in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_likes: Annotated[Optional[StrictBool], Field(description="Includes likes associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_versions: Annotated[Optional[StrictBool], Field(description="Includes versions associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_version: Annotated[Optional[StrictBool], Field(description="Includes the current version associated with this page in the response. By default this is included and can be omitted by setting the value to `false`.")] = None,
        include_favorited_by_current_user_status: Annotated[Optional[StrictBool], Field(description="Includes whether this page has been favorited by the current user.")] = None,
        include_webresources: Annotated[Optional[StrictBool], Field(description="Includes web resources that can be used to render page content on a client.")] = None,
        include_collaborators: Annotated[Optional[StrictBool], Field(description="Includes collaborators on the page.")] = None,
        include_direct_children: Annotated[Optional[StrictBool], Field(description="Includes direct children of the page, as defined in the `ChildrenResponse` object.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePage200Response:
        """Get page by id

        Returns a specific page.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space.

        :param id: The ID of the page to be returned. If you don't know the page ID, use Get pages and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentationSingle
        :param get_draft: Retrieve the draft version of this page.
        :type get_draft: bool
        :param status: Filter the page being retrieved by its status.
        :type status: List[str]
        :param version: Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.
        :type version: int
        :param include_labels: Includes labels associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param include_properties: Includes content properties associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_operations: Includes operations associated with this page in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_likes: Includes likes associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_likes: bool
        :param include_versions: Includes versions associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_versions: bool
        :param include_version: Includes the current version associated with this page in the response. By default this is included and can be omitted by setting the value to `false`.
        :type include_version: bool
        :param include_favorited_by_current_user_status: Includes whether this page has been favorited by the current user.
        :type include_favorited_by_current_user_status: bool
        :param include_webresources: Includes web resources that can be used to render page content on a client.
        :type include_webresources: bool
        :param include_collaborators: Includes collaborators on the page.
        :type include_collaborators: bool
        :param include_direct_children: Includes direct children of the page, as defined in the `ChildrenResponse` object.
        :type include_direct_children: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_page_by_id_serialize(
            id=id,
            body_format=body_format,
            get_draft=get_draft,
            status=status,
            version=version,
            include_labels=include_labels,
            include_properties=include_properties,
            include_operations=include_operations,
            include_likes=include_likes,
            include_versions=include_versions,
            include_version=include_version,
            include_favorited_by_current_user_status=include_favorited_by_current_user_status,
            include_webresources=include_webresources,
            include_collaborators=include_collaborators,
            include_direct_children=include_direct_children,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_page_by_id_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be returned. If you don't know the page ID, use Get pages and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentationSingle], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        get_draft: Annotated[Optional[StrictBool], Field(description="Retrieve the draft version of this page.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the page being retrieved by its status.")] = None,
        version: Annotated[Optional[StrictInt], Field(description="Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes content properties associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this page in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_likes: Annotated[Optional[StrictBool], Field(description="Includes likes associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_versions: Annotated[Optional[StrictBool], Field(description="Includes versions associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_version: Annotated[Optional[StrictBool], Field(description="Includes the current version associated with this page in the response. By default this is included and can be omitted by setting the value to `false`.")] = None,
        include_favorited_by_current_user_status: Annotated[Optional[StrictBool], Field(description="Includes whether this page has been favorited by the current user.")] = None,
        include_webresources: Annotated[Optional[StrictBool], Field(description="Includes web resources that can be used to render page content on a client.")] = None,
        include_collaborators: Annotated[Optional[StrictBool], Field(description="Includes collaborators on the page.")] = None,
        include_direct_children: Annotated[Optional[StrictBool], Field(description="Includes direct children of the page, as defined in the `ChildrenResponse` object.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePage200Response]:
        """Get page by id

        Returns a specific page.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space.

        :param id: The ID of the page to be returned. If you don't know the page ID, use Get pages and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentationSingle
        :param get_draft: Retrieve the draft version of this page.
        :type get_draft: bool
        :param status: Filter the page being retrieved by its status.
        :type status: List[str]
        :param version: Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.
        :type version: int
        :param include_labels: Includes labels associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param include_properties: Includes content properties associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_operations: Includes operations associated with this page in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_likes: Includes likes associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_likes: bool
        :param include_versions: Includes versions associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_versions: bool
        :param include_version: Includes the current version associated with this page in the response. By default this is included and can be omitted by setting the value to `false`.
        :type include_version: bool
        :param include_favorited_by_current_user_status: Includes whether this page has been favorited by the current user.
        :type include_favorited_by_current_user_status: bool
        :param include_webresources: Includes web resources that can be used to render page content on a client.
        :type include_webresources: bool
        :param include_collaborators: Includes collaborators on the page.
        :type include_collaborators: bool
        :param include_direct_children: Includes direct children of the page, as defined in the `ChildrenResponse` object.
        :type include_direct_children: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_page_by_id_serialize(
            id=id,
            body_format=body_format,
            get_draft=get_draft,
            status=status,
            version=version,
            include_labels=include_labels,
            include_properties=include_properties,
            include_operations=include_operations,
            include_likes=include_likes,
            include_versions=include_versions,
            include_version=include_version,
            include_favorited_by_current_user_status=include_favorited_by_current_user_status,
            include_webresources=include_webresources,
            include_collaborators=include_collaborators,
            include_direct_children=include_direct_children,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_page_by_id_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be returned. If you don't know the page ID, use Get pages and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentationSingle], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        get_draft: Annotated[Optional[StrictBool], Field(description="Retrieve the draft version of this page.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the page being retrieved by its status.")] = None,
        version: Annotated[Optional[StrictInt], Field(description="Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes content properties associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this page in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_likes: Annotated[Optional[StrictBool], Field(description="Includes likes associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_versions: Annotated[Optional[StrictBool], Field(description="Includes versions associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_version: Annotated[Optional[StrictBool], Field(description="Includes the current version associated with this page in the response. By default this is included and can be omitted by setting the value to `false`.")] = None,
        include_favorited_by_current_user_status: Annotated[Optional[StrictBool], Field(description="Includes whether this page has been favorited by the current user.")] = None,
        include_webresources: Annotated[Optional[StrictBool], Field(description="Includes web resources that can be used to render page content on a client.")] = None,
        include_collaborators: Annotated[Optional[StrictBool], Field(description="Includes collaborators on the page.")] = None,
        include_direct_children: Annotated[Optional[StrictBool], Field(description="Includes direct children of the page, as defined in the `ChildrenResponse` object.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get page by id

        Returns a specific page.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space.

        :param id: The ID of the page to be returned. If you don't know the page ID, use Get pages and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentationSingle
        :param get_draft: Retrieve the draft version of this page.
        :type get_draft: bool
        :param status: Filter the page being retrieved by its status.
        :type status: List[str]
        :param version: Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.
        :type version: int
        :param include_labels: Includes labels associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param include_properties: Includes content properties associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_operations: Includes operations associated with this page in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_likes: Includes likes associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_likes: bool
        :param include_versions: Includes versions associated with this page in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_versions: bool
        :param include_version: Includes the current version associated with this page in the response. By default this is included and can be omitted by setting the value to `false`.
        :type include_version: bool
        :param include_favorited_by_current_user_status: Includes whether this page has been favorited by the current user.
        :type include_favorited_by_current_user_status: bool
        :param include_webresources: Includes web resources that can be used to render page content on a client.
        :type include_webresources: bool
        :param include_collaborators: Includes collaborators on the page.
        :type include_collaborators: bool
        :param include_direct_children: Includes direct children of the page, as defined in the `ChildrenResponse` object.
        :type include_direct_children: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_page_by_id_serialize(
            id=id,
            body_format=body_format,
            get_draft=get_draft,
            status=status,
            version=version,
            include_labels=include_labels,
            include_properties=include_properties,
            include_operations=include_operations,
            include_likes=include_likes,
            include_versions=include_versions,
            include_version=include_version,
            include_favorited_by_current_user_status=include_favorited_by_current_user_status,
            include_webresources=include_webresources,
            include_collaborators=include_collaborators,
            include_direct_children=include_direct_children,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_page_by_id_serialize(
        self,
        id,
        body_format,
        get_draft,
        status,
        version,
        include_labels,
        include_properties,
        include_operations,
        include_likes,
        include_versions,
        include_version,
        include_favorited_by_current_user_status,
        include_webresources,
        include_collaborators,
        include_direct_children,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'status': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if get_draft is not None:
            
            _query_params.append(('get-draft', get_draft))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if version is not None:
            
            _query_params.append(('version', version))
            
        if include_labels is not None:
            
            _query_params.append(('include-labels', include_labels))
            
        if include_properties is not None:
            
            _query_params.append(('include-properties', include_properties))
            
        if include_operations is not None:
            
            _query_params.append(('include-operations', include_operations))
            
        if include_likes is not None:
            
            _query_params.append(('include-likes', include_likes))
            
        if include_versions is not None:
            
            _query_params.append(('include-versions', include_versions))
            
        if include_version is not None:
            
            _query_params.append(('include-version', include_version))
            
        if include_favorited_by_current_user_status is not None:
            
            _query_params.append(('include-favorited-by-current-user-status', include_favorited_by_current_user_status))
            
        if include_webresources is not None:
            
            _query_params.append(('include-webresources', include_webresources))
            
        if include_collaborators is not None:
            
            _query_params.append(('include-collaborators', include_collaborators))
            
        if include_direct_children is not None:
            
            _query_params.append(('include-direct-children', include_direct_children))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pages/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_pages(
        self,
        id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results based on page ids. Multiple page ids can be specified as a comma-separated list.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to pages based on their status. By default, `current` and `archived` are used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        subtype: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their subtype.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MultiEntityResultPage:
        """Get pages

        Returns all pages. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only pages that the user has permission to view will be returned.

        :param id: Filter the results based on page ids. Multiple page ids can be specified as a comma-separated list.
        :type id: List[int]
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param status: Filter the results to pages based on their status. By default, `current` and `archived` are used.
        :type status: List[str]
        :param title: Filter the results to pages based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param subtype: Filter the results to pages based on their subtype.
        :type subtype: str
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pages_serialize(
            id=id,
            space_id=space_id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            subtype=subtype,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_pages_with_http_info(
        self,
        id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results based on page ids. Multiple page ids can be specified as a comma-separated list.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to pages based on their status. By default, `current` and `archived` are used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        subtype: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their subtype.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MultiEntityResultPage]:
        """Get pages

        Returns all pages. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only pages that the user has permission to view will be returned.

        :param id: Filter the results based on page ids. Multiple page ids can be specified as a comma-separated list.
        :type id: List[int]
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param status: Filter the results to pages based on their status. By default, `current` and `archived` are used.
        :type status: List[str]
        :param title: Filter the results to pages based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param subtype: Filter the results to pages based on their subtype.
        :type subtype: str
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pages_serialize(
            id=id,
            space_id=space_id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            subtype=subtype,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_pages_without_preload_content(
        self,
        id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results based on page ids. Multiple page ids can be specified as a comma-separated list.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to pages based on their status. By default, `current` and `archived` are used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        subtype: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their subtype.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get pages

        Returns all pages. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only pages that the user has permission to view will be returned.

        :param id: Filter the results based on page ids. Multiple page ids can be specified as a comma-separated list.
        :type id: List[int]
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param status: Filter the results to pages based on their status. By default, `current` and `archived` are used.
        :type status: List[str]
        :param title: Filter the results to pages based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param subtype: Filter the results to pages based on their subtype.
        :type subtype: str
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pages_serialize(
            id=id,
            space_id=space_id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            subtype=subtype,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_pages_serialize(
        self,
        id,
        space_id,
        sort,
        status,
        title,
        body_format,
        subtype,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'id': 'multi',
            'space-id': 'multi',
            'status': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if space_id is not None:
            
            _query_params.append(('space-id', space_id))
            
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if subtype is not None:
            
            _query_params.append(('subtype', subtype))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_pages_in_space(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space for which pages should be returned.")],
        depth: Annotated[Optional[StrictStr], Field(description="Filter the results to pages at the root level of the space or to all pages in the space.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to pages based on their status. By default, `current` and `archived` are used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MultiEntityResultPage:
        """Get pages in space

        Returns all pages in a space. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission) and 'View' permission for the space. Only pages that the user has permission to view will be returned.

        :param id: The ID of the space for which pages should be returned. (required)
        :type id: int
        :param depth: Filter the results to pages at the root level of the space or to all pages in the space.
        :type depth: str
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param status: Filter the results to pages based on their status. By default, `current` and `archived` are used.
        :type status: List[str]
        :param title: Filter the results to pages based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pages_in_space_serialize(
            id=id,
            depth=depth,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_pages_in_space_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space for which pages should be returned.")],
        depth: Annotated[Optional[StrictStr], Field(description="Filter the results to pages at the root level of the space or to all pages in the space.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to pages based on their status. By default, `current` and `archived` are used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MultiEntityResultPage]:
        """Get pages in space

        Returns all pages in a space. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission) and 'View' permission for the space. Only pages that the user has permission to view will be returned.

        :param id: The ID of the space for which pages should be returned. (required)
        :type id: int
        :param depth: Filter the results to pages at the root level of the space or to all pages in the space.
        :type depth: str
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param status: Filter the results to pages based on their status. By default, `current` and `archived` are used.
        :type status: List[str]
        :param title: Filter the results to pages based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pages_in_space_serialize(
            id=id,
            depth=depth,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_pages_in_space_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space for which pages should be returned.")],
        depth: Annotated[Optional[StrictStr], Field(description="Filter the results to pages at the root level of the space or to all pages in the space.")] = None,
        sort: Annotated[Optional[PageSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to pages based on their status. By default, `current` and `archived` are used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to pages based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get pages in space

        Returns all pages in a space. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission) and 'View' permission for the space. Only pages that the user has permission to view will be returned.

        :param id: The ID of the space for which pages should be returned. (required)
        :type id: int
        :param depth: Filter the results to pages at the root level of the space or to all pages in the space.
        :type depth: str
        :param sort: Used to sort the result by a particular field.
        :type sort: PageSortOrder
        :param status: Filter the results to pages based on their status. By default, `current` and `archived` are used.
        :type status: List[str]
        :param title: Filter the results to pages based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of pages per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pages_in_space_serialize(
            id=id,
            depth=depth,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultPage",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_pages_in_space_serialize(
        self,
        id,
        depth,
        sort,
        status,
        title,
        body_format,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'status': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if depth is not None:
            
            _query_params.append(('depth', depth))
            
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/spaces/{id}/pages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_page(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results.")],
        update_page_request: UpdatePageRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePage200Response:
        """Update page

        Update a page by id.  When the \"current\" version is updated, the provided body content is considered as the latest version. This latest body content will be attempted to be merged into the draft version through a content reconciliation algorithm. If two versions are significantly diverged,  the latest provided content may entirely override what was previously in the draft.   **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to update pages in the space.

        :param id: The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results. (required)
        :type id: int
        :param update_page_request: (required)
        :type update_page_request: UpdatePageRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_page_serialize(
            id=id,
            update_page_request=update_page_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_page_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results.")],
        update_page_request: UpdatePageRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePage200Response]:
        """Update page

        Update a page by id.  When the \"current\" version is updated, the provided body content is considered as the latest version. This latest body content will be attempted to be merged into the draft version through a content reconciliation algorithm. If two versions are significantly diverged,  the latest provided content may entirely override what was previously in the draft.   **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to update pages in the space.

        :param id: The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results. (required)
        :type id: int
        :param update_page_request: (required)
        :type update_page_request: UpdatePageRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_page_serialize(
            id=id,
            update_page_request=update_page_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_page_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results.")],
        update_page_request: UpdatePageRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update page

        Update a page by id.  When the \"current\" version is updated, the provided body content is considered as the latest version. This latest body content will be attempted to be merged into the draft version through a content reconciliation algorithm. If two versions are significantly diverged,  the latest provided content may entirely override what was previously in the draft.   **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to update pages in the space.

        :param id: The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results. (required)
        :type id: int
        :param update_page_request: (required)
        :type update_page_request: UpdatePageRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_page_serialize(
            id=id,
            update_page_request=update_page_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_page_serialize(
        self,
        id,
        update_page_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_page_request is not None:
            _body_params = update_page_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/pages/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_page_title(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results")],
        update_page_title_request: UpdatePageTitleRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePage200Response:
        """Update page title

        Updates the title of a specified page.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to update pages in the space.

        :param id: The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results (required)
        :type id: int
        :param update_page_title_request: (required)
        :type update_page_title_request: UpdatePageTitleRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_page_title_serialize(
            id=id,
            update_page_title_request=update_page_title_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_page_title_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results")],
        update_page_title_request: UpdatePageTitleRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePage200Response]:
        """Update page title

        Updates the title of a specified page.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to update pages in the space.

        :param id: The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results (required)
        :type id: int
        :param update_page_title_request: (required)
        :type update_page_title_request: UpdatePageTitleRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_page_title_serialize(
            id=id,
            update_page_title_request=update_page_title_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_page_title_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results")],
        update_page_title_request: UpdatePageTitleRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update page title

        Updates the title of a specified page.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the page and its corresponding space. Permission to update pages in the space.

        :param id: The ID of the page to be updated. If you don't know the page ID, use Get Pages and filter the results (required)
        :type id: int
        :param update_page_title_request: (required)
        :type update_page_title_request: UpdatePageTitleRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_page_title_serialize(
            id=id,
            update_page_title_request=update_page_title_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePage200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_page_title_serialize(
        self,
        id,
        update_page_title_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_page_title_request is not None:
            _body_params = update_page_title_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/pages/{id}/title',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


