# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from devopso.clients.confluence_cloud.models.create_space201_response import CreateSpace201Response
from devopso.clients.confluence_cloud.models.create_space_request import CreateSpaceRequest
from devopso.clients.confluence_cloud.models.get_space_by_id200_response import GetSpaceById200Response
from devopso.clients.confluence_cloud.models.multi_entity_result_space import MultiEntityResultSpace
from devopso.clients.confluence_cloud.models.space_description_body_representation import SpaceDescriptionBodyRepresentation
from devopso.clients.confluence_cloud.models.space_sort_order import SpaceSortOrder

from devopso.clients.confluence_cloud.api_client import ApiClient, RequestSerialized
from devopso.clients.confluence_cloud.api_response import ApiResponse
from devopso.clients.confluence_cloud.rest import RESTResponseType


class SpaceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_space(
        self,
        create_space_request: CreateSpaceRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateSpace201Response:
        """Create space

        Creates a Space as specified in the payload.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to create spaces.

        :param create_space_request: (required)
        :type create_space_request: CreateSpaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_space_serialize(
            create_space_request=create_space_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateSpace201Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_space_with_http_info(
        self,
        create_space_request: CreateSpaceRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateSpace201Response]:
        """Create space

        Creates a Space as specified in the payload.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to create spaces.

        :param create_space_request: (required)
        :type create_space_request: CreateSpaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_space_serialize(
            create_space_request=create_space_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateSpace201Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_space_without_preload_content(
        self,
        create_space_request: CreateSpaceRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create space

        Creates a Space as specified in the payload.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to create spaces.

        :param create_space_request: (required)
        :type create_space_request: CreateSpaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_space_serialize(
            create_space_request=create_space_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateSpace201Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_space_serialize(
        self,
        create_space_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_space_request is not None:
            _body_params = create_space_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/spaces',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_space_by_id(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space to be returned.")],
        description_format: Annotated[Optional[SpaceDescriptionBodyRepresentation], Field(description="The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.")] = None,
        include_icon: Annotated[Optional[StrictBool], Field(description="If the icon for the space should be fetched or not.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this space in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes space properties associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_permissions: Annotated[Optional[StrictBool], Field(description="Includes space permissions associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_role_assignments: Annotated[Optional[StrictBool], Field(description="Includes role assignments associated with this space in the response. This parameter is only accepted for EAP sites. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetSpaceById200Response:
        """Get space by id

        Returns a specific space.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the space.

        :param id: The ID of the space to be returned. (required)
        :type id: int
        :param description_format: The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.
        :type description_format: SpaceDescriptionBodyRepresentation
        :param include_icon: If the icon for the space should be fetched or not.
        :type include_icon: bool
        :param include_operations: Includes operations associated with this space in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_properties: Includes space properties associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_permissions: Includes space permissions associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_permissions: bool
        :param include_role_assignments: Includes role assignments associated with this space in the response. This parameter is only accepted for EAP sites. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_role_assignments: bool
        :param include_labels: Includes labels associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_space_by_id_serialize(
            id=id,
            description_format=description_format,
            include_icon=include_icon,
            include_operations=include_operations,
            include_properties=include_properties,
            include_permissions=include_permissions,
            include_role_assignments=include_role_assignments,
            include_labels=include_labels,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSpaceById200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_space_by_id_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space to be returned.")],
        description_format: Annotated[Optional[SpaceDescriptionBodyRepresentation], Field(description="The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.")] = None,
        include_icon: Annotated[Optional[StrictBool], Field(description="If the icon for the space should be fetched or not.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this space in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes space properties associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_permissions: Annotated[Optional[StrictBool], Field(description="Includes space permissions associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_role_assignments: Annotated[Optional[StrictBool], Field(description="Includes role assignments associated with this space in the response. This parameter is only accepted for EAP sites. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetSpaceById200Response]:
        """Get space by id

        Returns a specific space.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the space.

        :param id: The ID of the space to be returned. (required)
        :type id: int
        :param description_format: The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.
        :type description_format: SpaceDescriptionBodyRepresentation
        :param include_icon: If the icon for the space should be fetched or not.
        :type include_icon: bool
        :param include_operations: Includes operations associated with this space in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_properties: Includes space properties associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_permissions: Includes space permissions associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_permissions: bool
        :param include_role_assignments: Includes role assignments associated with this space in the response. This parameter is only accepted for EAP sites. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_role_assignments: bool
        :param include_labels: Includes labels associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_space_by_id_serialize(
            id=id,
            description_format=description_format,
            include_icon=include_icon,
            include_operations=include_operations,
            include_properties=include_properties,
            include_permissions=include_permissions,
            include_role_assignments=include_role_assignments,
            include_labels=include_labels,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSpaceById200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_space_by_id_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space to be returned.")],
        description_format: Annotated[Optional[SpaceDescriptionBodyRepresentation], Field(description="The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.")] = None,
        include_icon: Annotated[Optional[StrictBool], Field(description="If the icon for the space should be fetched or not.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this space in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes space properties associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_permissions: Annotated[Optional[StrictBool], Field(description="Includes space permissions associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_role_assignments: Annotated[Optional[StrictBool], Field(description="Includes role assignments associated with this space in the response. This parameter is only accepted for EAP sites. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get space by id

        Returns a specific space.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the space.

        :param id: The ID of the space to be returned. (required)
        :type id: int
        :param description_format: The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.
        :type description_format: SpaceDescriptionBodyRepresentation
        :param include_icon: If the icon for the space should be fetched or not.
        :type include_icon: bool
        :param include_operations: Includes operations associated with this space in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_properties: Includes space properties associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_permissions: Includes space permissions associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_permissions: bool
        :param include_role_assignments: Includes role assignments associated with this space in the response. This parameter is only accepted for EAP sites. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_role_assignments: bool
        :param include_labels: Includes labels associated with this space in the response. The number of results will be limited to 50 and sorted in the default sort order. A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_space_by_id_serialize(
            id=id,
            description_format=description_format,
            include_icon=include_icon,
            include_operations=include_operations,
            include_properties=include_properties,
            include_permissions=include_permissions,
            include_role_assignments=include_role_assignments,
            include_labels=include_labels,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSpaceById200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_space_by_id_serialize(
        self,
        id,
        description_format,
        include_icon,
        include_operations,
        include_properties,
        include_permissions,
        include_role_assignments,
        include_labels,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if description_format is not None:
            
            _query_params.append(('description-format', description_format.value))
            
        if include_icon is not None:
            
            _query_params.append(('include-icon', include_icon))
            
        if include_operations is not None:
            
            _query_params.append(('include-operations', include_operations))
            
        if include_properties is not None:
            
            _query_params.append(('include-properties', include_properties))
            
        if include_permissions is not None:
            
            _query_params.append(('include-permissions', include_permissions))
            
        if include_role_assignments is not None:
            
            _query_params.append(('include-role-assignments', include_role_assignments))
            
        if include_labels is not None:
            
            _query_params.append(('include-labels', include_labels))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/spaces/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_spaces(
        self,
        ids: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results to spaces based on their IDs. Multiple IDs can be specified as a comma-separated list.")] = None,
        keys: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filter the results to spaces based on their keys. Multiple keys can be specified as a comma-separated list.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces based on their type.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces based on their status.")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to spaces based on their labels. Multiple labels can be specified as a comma-separated list.")] = None,
        favorited_by: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces favorited by the user with the specified account ID.")] = None,
        not_favorited_by: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces NOT favorited by the user with the specified account ID.")] = None,
        sort: Annotated[Optional[SpaceSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        description_format: Annotated[Optional[SpaceDescriptionBodyRepresentation], Field(description="The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.")] = None,
        include_icon: Annotated[Optional[StrictBool], Field(description="If the icon for the space should be fetched or not.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of spaces per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MultiEntityResultSpace:
        """Get spaces

        Returns all spaces. The results will be sorted by id ascending. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only spaces that the user has permission to view will be returned.

        :param ids: Filter the results to spaces based on their IDs. Multiple IDs can be specified as a comma-separated list.
        :type ids: List[int]
        :param keys: Filter the results to spaces based on their keys. Multiple keys can be specified as a comma-separated list.
        :type keys: List[str]
        :param type: Filter the results to spaces based on their type.
        :type type: str
        :param status: Filter the results to spaces based on their status.
        :type status: str
        :param labels: Filter the results to spaces based on their labels. Multiple labels can be specified as a comma-separated list.
        :type labels: List[str]
        :param favorited_by: Filter the results to spaces favorited by the user with the specified account ID.
        :type favorited_by: str
        :param not_favorited_by: Filter the results to spaces NOT favorited by the user with the specified account ID.
        :type not_favorited_by: str
        :param sort: Used to sort the result by a particular field.
        :type sort: SpaceSortOrder
        :param description_format: The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.
        :type description_format: SpaceDescriptionBodyRepresentation
        :param include_icon: If the icon for the space should be fetched or not.
        :type include_icon: bool
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of spaces per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_spaces_serialize(
            ids=ids,
            keys=keys,
            type=type,
            status=status,
            labels=labels,
            favorited_by=favorited_by,
            not_favorited_by=not_favorited_by,
            sort=sort,
            description_format=description_format,
            include_icon=include_icon,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultSpace",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_spaces_with_http_info(
        self,
        ids: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results to spaces based on their IDs. Multiple IDs can be specified as a comma-separated list.")] = None,
        keys: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filter the results to spaces based on their keys. Multiple keys can be specified as a comma-separated list.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces based on their type.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces based on their status.")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to spaces based on their labels. Multiple labels can be specified as a comma-separated list.")] = None,
        favorited_by: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces favorited by the user with the specified account ID.")] = None,
        not_favorited_by: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces NOT favorited by the user with the specified account ID.")] = None,
        sort: Annotated[Optional[SpaceSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        description_format: Annotated[Optional[SpaceDescriptionBodyRepresentation], Field(description="The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.")] = None,
        include_icon: Annotated[Optional[StrictBool], Field(description="If the icon for the space should be fetched or not.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of spaces per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MultiEntityResultSpace]:
        """Get spaces

        Returns all spaces. The results will be sorted by id ascending. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only spaces that the user has permission to view will be returned.

        :param ids: Filter the results to spaces based on their IDs. Multiple IDs can be specified as a comma-separated list.
        :type ids: List[int]
        :param keys: Filter the results to spaces based on their keys. Multiple keys can be specified as a comma-separated list.
        :type keys: List[str]
        :param type: Filter the results to spaces based on their type.
        :type type: str
        :param status: Filter the results to spaces based on their status.
        :type status: str
        :param labels: Filter the results to spaces based on their labels. Multiple labels can be specified as a comma-separated list.
        :type labels: List[str]
        :param favorited_by: Filter the results to spaces favorited by the user with the specified account ID.
        :type favorited_by: str
        :param not_favorited_by: Filter the results to spaces NOT favorited by the user with the specified account ID.
        :type not_favorited_by: str
        :param sort: Used to sort the result by a particular field.
        :type sort: SpaceSortOrder
        :param description_format: The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.
        :type description_format: SpaceDescriptionBodyRepresentation
        :param include_icon: If the icon for the space should be fetched or not.
        :type include_icon: bool
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of spaces per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_spaces_serialize(
            ids=ids,
            keys=keys,
            type=type,
            status=status,
            labels=labels,
            favorited_by=favorited_by,
            not_favorited_by=not_favorited_by,
            sort=sort,
            description_format=description_format,
            include_icon=include_icon,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultSpace",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_spaces_without_preload_content(
        self,
        ids: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results to spaces based on their IDs. Multiple IDs can be specified as a comma-separated list.")] = None,
        keys: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filter the results to spaces based on their keys. Multiple keys can be specified as a comma-separated list.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces based on their type.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces based on their status.")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to spaces based on their labels. Multiple labels can be specified as a comma-separated list.")] = None,
        favorited_by: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces favorited by the user with the specified account ID.")] = None,
        not_favorited_by: Annotated[Optional[StrictStr], Field(description="Filter the results to spaces NOT favorited by the user with the specified account ID.")] = None,
        sort: Annotated[Optional[SpaceSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        description_format: Annotated[Optional[SpaceDescriptionBodyRepresentation], Field(description="The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.")] = None,
        include_icon: Annotated[Optional[StrictBool], Field(description="If the icon for the space should be fetched or not.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of spaces per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get spaces

        Returns all spaces. The results will be sorted by id ascending. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only spaces that the user has permission to view will be returned.

        :param ids: Filter the results to spaces based on their IDs. Multiple IDs can be specified as a comma-separated list.
        :type ids: List[int]
        :param keys: Filter the results to spaces based on their keys. Multiple keys can be specified as a comma-separated list.
        :type keys: List[str]
        :param type: Filter the results to spaces based on their type.
        :type type: str
        :param status: Filter the results to spaces based on their status.
        :type status: str
        :param labels: Filter the results to spaces based on their labels. Multiple labels can be specified as a comma-separated list.
        :type labels: List[str]
        :param favorited_by: Filter the results to spaces favorited by the user with the specified account ID.
        :type favorited_by: str
        :param not_favorited_by: Filter the results to spaces NOT favorited by the user with the specified account ID.
        :type not_favorited_by: str
        :param sort: Used to sort the result by a particular field.
        :type sort: SpaceSortOrder
        :param description_format: The content format type to be returned in the `description` field of the response. If available, the representation will be available under a response field of the same name under the `description` field.
        :type description_format: SpaceDescriptionBodyRepresentation
        :param include_icon: If the icon for the space should be fetched or not.
        :type include_icon: bool
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of spaces per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_spaces_serialize(
            ids=ids,
            keys=keys,
            type=type,
            status=status,
            labels=labels,
            favorited_by=favorited_by,
            not_favorited_by=not_favorited_by,
            sort=sort,
            description_format=description_format,
            include_icon=include_icon,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultSpace",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_spaces_serialize(
        self,
        ids,
        keys,
        type,
        status,
        labels,
        favorited_by,
        not_favorited_by,
        sort,
        description_format,
        include_icon,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'ids': 'multi',
            'keys': 'multi',
            'labels': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if ids is not None:
            
            _query_params.append(('ids', ids))
            
        if keys is not None:
            
            _query_params.append(('keys', keys))
            
        if type is not None:
            
            _query_params.append(('type', type))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if labels is not None:
            
            _query_params.append(('labels', labels))
            
        if favorited_by is not None:
            
            _query_params.append(('favorited-by', favorited_by))
            
        if not_favorited_by is not None:
            
            _query_params.append(('not-favorited-by', not_favorited_by))
            
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if description_format is not None:
            
            _query_params.append(('description-format', description_format.value))
            
        if include_icon is not None:
            
            _query_params.append(('include-icon', include_icon))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/spaces',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


