# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from devopso.clients.confluence_cloud.models.multi_entity_result_task import MultiEntityResultTask
from devopso.clients.confluence_cloud.models.primary_body_representation import PrimaryBodyRepresentation
from devopso.clients.confluence_cloud.models.task import Task
from devopso.clients.confluence_cloud.models.update_task_request import UpdateTaskRequest

from devopso.clients.confluence_cloud.api_client import ApiClient, RequestSerialized
from devopso.clients.confluence_cloud.api_response import ApiResponse
from devopso.clients.confluence_cloud.rest import RESTResponseType


class TaskApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_task_by_id(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the task to be returned. If you don't know the task ID, use Get tasks and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Task:
        """Get task by id

        Returns a specific task.   **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the containing page or blog post and its corresponding space.

        :param id: The ID of the task to be returned. If you don't know the task ID, use Get tasks and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_task_by_id_serialize(
            id=id,
            body_format=body_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Task",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_task_by_id_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the task to be returned. If you don't know the task ID, use Get tasks and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Task]:
        """Get task by id

        Returns a specific task.   **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the containing page or blog post and its corresponding space.

        :param id: The ID of the task to be returned. If you don't know the task ID, use Get tasks and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_task_by_id_serialize(
            id=id,
            body_format=body_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Task",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_task_by_id_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the task to be returned. If you don't know the task ID, use Get tasks and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get task by id

        Returns a specific task.   **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the containing page or blog post and its corresponding space.

        :param id: The ID of the task to be returned. If you don't know the task ID, use Get tasks and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_task_by_id_serialize(
            id=id,
            body_format=body_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Task",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_task_by_id_serialize(
        self,
        id,
        body_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/tasks/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_tasks(
        self,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        include_blank_tasks: Annotated[Optional[StrictBool], Field(description="Specifies whether to include blank tasks in the response. Defaults to `true`.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filters on the status of the task.")] = None,
        task_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on task ID. Multiple IDs can be specified.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the space ID of the task. Multiple IDs can be specified.")] = None,
        page_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the page ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.")] = None,
        blogpost_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the blog post ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.")] = None,
        created_by: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user who created this task. Multiple IDs can be specified.")] = None,
        assigned_to: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user to whom this task is assigned. Multiple IDs can be specified.")] = None,
        completed_by: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user who completed this task. Multiple IDs can be specified.")] = None,
        created_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.")] = None,
        created_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.")] = None,
        due_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.")] = None,
        due_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.")] = None,
        completed_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.")] = None,
        completed_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of tasks per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MultiEntityResultTask:
        """Get tasks

        Returns all tasks. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only tasks that the user has permission to view will be returned.

        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param include_blank_tasks: Specifies whether to include blank tasks in the response. Defaults to `true`.
        :type include_blank_tasks: bool
        :param status: Filters on the status of the task.
        :type status: str
        :param task_id: Filters on task ID. Multiple IDs can be specified.
        :type task_id: List[int]
        :param space_id: Filters on the space ID of the task. Multiple IDs can be specified.
        :type space_id: List[int]
        :param page_id: Filters on the page ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.
        :type page_id: List[int]
        :param blogpost_id: Filters on the blog post ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.
        :type blogpost_id: List[int]
        :param created_by: Filters on the Account ID of the user who created this task. Multiple IDs can be specified.
        :type created_by: List[str]
        :param assigned_to: Filters on the Account ID of the user to whom this task is assigned. Multiple IDs can be specified.
        :type assigned_to: List[str]
        :param completed_by: Filters on the Account ID of the user who completed this task. Multiple IDs can be specified.
        :type completed_by: List[str]
        :param created_at_from: Filters on start of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.
        :type created_at_from: int
        :param created_at_to: Filters on end of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.
        :type created_at_to: int
        :param due_at_from: Filters on start of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.
        :type due_at_from: int
        :param due_at_to: Filters on end of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.
        :type due_at_to: int
        :param completed_at_from: Filters on start of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.
        :type completed_at_from: int
        :param completed_at_to: Filters on end of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.
        :type completed_at_to: int
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of tasks per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tasks_serialize(
            body_format=body_format,
            include_blank_tasks=include_blank_tasks,
            status=status,
            task_id=task_id,
            space_id=space_id,
            page_id=page_id,
            blogpost_id=blogpost_id,
            created_by=created_by,
            assigned_to=assigned_to,
            completed_by=completed_by,
            created_at_from=created_at_from,
            created_at_to=created_at_to,
            due_at_from=due_at_from,
            due_at_to=due_at_to,
            completed_at_from=completed_at_from,
            completed_at_to=completed_at_to,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultTask",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_tasks_with_http_info(
        self,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        include_blank_tasks: Annotated[Optional[StrictBool], Field(description="Specifies whether to include blank tasks in the response. Defaults to `true`.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filters on the status of the task.")] = None,
        task_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on task ID. Multiple IDs can be specified.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the space ID of the task. Multiple IDs can be specified.")] = None,
        page_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the page ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.")] = None,
        blogpost_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the blog post ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.")] = None,
        created_by: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user who created this task. Multiple IDs can be specified.")] = None,
        assigned_to: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user to whom this task is assigned. Multiple IDs can be specified.")] = None,
        completed_by: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user who completed this task. Multiple IDs can be specified.")] = None,
        created_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.")] = None,
        created_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.")] = None,
        due_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.")] = None,
        due_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.")] = None,
        completed_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.")] = None,
        completed_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of tasks per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MultiEntityResultTask]:
        """Get tasks

        Returns all tasks. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only tasks that the user has permission to view will be returned.

        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param include_blank_tasks: Specifies whether to include blank tasks in the response. Defaults to `true`.
        :type include_blank_tasks: bool
        :param status: Filters on the status of the task.
        :type status: str
        :param task_id: Filters on task ID. Multiple IDs can be specified.
        :type task_id: List[int]
        :param space_id: Filters on the space ID of the task. Multiple IDs can be specified.
        :type space_id: List[int]
        :param page_id: Filters on the page ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.
        :type page_id: List[int]
        :param blogpost_id: Filters on the blog post ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.
        :type blogpost_id: List[int]
        :param created_by: Filters on the Account ID of the user who created this task. Multiple IDs can be specified.
        :type created_by: List[str]
        :param assigned_to: Filters on the Account ID of the user to whom this task is assigned. Multiple IDs can be specified.
        :type assigned_to: List[str]
        :param completed_by: Filters on the Account ID of the user who completed this task. Multiple IDs can be specified.
        :type completed_by: List[str]
        :param created_at_from: Filters on start of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.
        :type created_at_from: int
        :param created_at_to: Filters on end of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.
        :type created_at_to: int
        :param due_at_from: Filters on start of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.
        :type due_at_from: int
        :param due_at_to: Filters on end of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.
        :type due_at_to: int
        :param completed_at_from: Filters on start of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.
        :type completed_at_from: int
        :param completed_at_to: Filters on end of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.
        :type completed_at_to: int
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of tasks per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tasks_serialize(
            body_format=body_format,
            include_blank_tasks=include_blank_tasks,
            status=status,
            task_id=task_id,
            space_id=space_id,
            page_id=page_id,
            blogpost_id=blogpost_id,
            created_by=created_by,
            assigned_to=assigned_to,
            completed_by=completed_by,
            created_at_from=created_at_from,
            created_at_to=created_at_to,
            due_at_from=due_at_from,
            due_at_to=due_at_to,
            completed_at_from=completed_at_from,
            completed_at_to=completed_at_to,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultTask",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_tasks_without_preload_content(
        self,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        include_blank_tasks: Annotated[Optional[StrictBool], Field(description="Specifies whether to include blank tasks in the response. Defaults to `true`.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filters on the status of the task.")] = None,
        task_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on task ID. Multiple IDs can be specified.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the space ID of the task. Multiple IDs can be specified.")] = None,
        page_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the page ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.")] = None,
        blogpost_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filters on the blog post ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.")] = None,
        created_by: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user who created this task. Multiple IDs can be specified.")] = None,
        assigned_to: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user to whom this task is assigned. Multiple IDs can be specified.")] = None,
        completed_by: Annotated[Optional[Annotated[List[StrictStr], Field(max_length=250)]], Field(description="Filters on the Account ID of the user who completed this task. Multiple IDs can be specified.")] = None,
        created_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.")] = None,
        created_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.")] = None,
        due_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.")] = None,
        due_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.")] = None,
        completed_at_from: Annotated[Optional[StrictInt], Field(description="Filters on start of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.")] = None,
        completed_at_to: Annotated[Optional[StrictInt], Field(description="Filters on end of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of tasks per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get tasks

        Returns all tasks. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only tasks that the user has permission to view will be returned.

        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param include_blank_tasks: Specifies whether to include blank tasks in the response. Defaults to `true`.
        :type include_blank_tasks: bool
        :param status: Filters on the status of the task.
        :type status: str
        :param task_id: Filters on task ID. Multiple IDs can be specified.
        :type task_id: List[int]
        :param space_id: Filters on the space ID of the task. Multiple IDs can be specified.
        :type space_id: List[int]
        :param page_id: Filters on the page ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.
        :type page_id: List[int]
        :param blogpost_id: Filters on the blog post ID of the task. Multiple IDs can be specified. Note - page and blog post filters can be used in conjunction.
        :type blogpost_id: List[int]
        :param created_by: Filters on the Account ID of the user who created this task. Multiple IDs can be specified.
        :type created_by: List[str]
        :param assigned_to: Filters on the Account ID of the user to whom this task is assigned. Multiple IDs can be specified.
        :type assigned_to: List[str]
        :param completed_by: Filters on the Account ID of the user who completed this task. Multiple IDs can be specified.
        :type completed_by: List[str]
        :param created_at_from: Filters on start of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.
        :type created_at_from: int
        :param created_at_to: Filters on end of date-time range of task based on creation date (inclusive). Input is epoch time in milliseconds.
        :type created_at_to: int
        :param due_at_from: Filters on start of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.
        :type due_at_from: int
        :param due_at_to: Filters on end of date-time range of task based on due date (inclusive). Input is epoch time in milliseconds.
        :type due_at_to: int
        :param completed_at_from: Filters on start of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.
        :type completed_at_from: int
        :param completed_at_to: Filters on end of date-time range of task based on completion date (inclusive). Input is epoch time in milliseconds.
        :type completed_at_to: int
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of tasks per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tasks_serialize(
            body_format=body_format,
            include_blank_tasks=include_blank_tasks,
            status=status,
            task_id=task_id,
            space_id=space_id,
            page_id=page_id,
            blogpost_id=blogpost_id,
            created_by=created_by,
            assigned_to=assigned_to,
            completed_by=completed_by,
            created_at_from=created_at_from,
            created_at_to=created_at_to,
            due_at_from=due_at_from,
            due_at_to=due_at_to,
            completed_at_from=completed_at_from,
            completed_at_to=completed_at_to,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultTask",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_tasks_serialize(
        self,
        body_format,
        include_blank_tasks,
        status,
        task_id,
        space_id,
        page_id,
        blogpost_id,
        created_by,
        assigned_to,
        completed_by,
        created_at_from,
        created_at_to,
        due_at_from,
        due_at_to,
        completed_at_from,
        completed_at_to,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'task-id': 'multi',
            'space-id': 'multi',
            'page-id': 'multi',
            'blogpost-id': 'multi',
            'created-by': 'multi',
            'assigned-to': 'multi',
            'completed-by': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if include_blank_tasks is not None:
            
            _query_params.append(('include-blank-tasks', include_blank_tasks))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if task_id is not None:
            
            _query_params.append(('task-id', task_id))
            
        if space_id is not None:
            
            _query_params.append(('space-id', space_id))
            
        if page_id is not None:
            
            _query_params.append(('page-id', page_id))
            
        if blogpost_id is not None:
            
            _query_params.append(('blogpost-id', blogpost_id))
            
        if created_by is not None:
            
            _query_params.append(('created-by', created_by))
            
        if assigned_to is not None:
            
            _query_params.append(('assigned-to', assigned_to))
            
        if completed_by is not None:
            
            _query_params.append(('completed-by', completed_by))
            
        if created_at_from is not None:
            
            _query_params.append(('created-at-from', created_at_from))
            
        if created_at_to is not None:
            
            _query_params.append(('created-at-to', created_at_to))
            
        if due_at_from is not None:
            
            _query_params.append(('due-at-from', due_at_from))
            
        if due_at_to is not None:
            
            _query_params.append(('due-at-to', due_at_to))
            
        if completed_at_from is not None:
            
            _query_params.append(('completed-at-from', completed_at_from))
            
        if completed_at_to is not None:
            
            _query_params.append(('completed-at-to', completed_at_to))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/tasks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_task(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the task to be updated. If you don't know the task ID, use Get tasks and filter the results.")],
        update_task_request: UpdateTaskRequest,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Task:
        """Update task

        Update a task by id. This endpoint currently only supports updating task status.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to edit the containing page or blog post and view its corresponding space.

        :param id: The ID of the task to be updated. If you don't know the task ID, use Get tasks and filter the results. (required)
        :type id: int
        :param update_task_request: (required)
        :type update_task_request: UpdateTaskRequest
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_task_serialize(
            id=id,
            update_task_request=update_task_request,
            body_format=body_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Task",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_task_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the task to be updated. If you don't know the task ID, use Get tasks and filter the results.")],
        update_task_request: UpdateTaskRequest,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Task]:
        """Update task

        Update a task by id. This endpoint currently only supports updating task status.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to edit the containing page or blog post and view its corresponding space.

        :param id: The ID of the task to be updated. If you don't know the task ID, use Get tasks and filter the results. (required)
        :type id: int
        :param update_task_request: (required)
        :type update_task_request: UpdateTaskRequest
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_task_serialize(
            id=id,
            update_task_request=update_task_request,
            body_format=body_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Task",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_task_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the task to be updated. If you don't know the task ID, use Get tasks and filter the results.")],
        update_task_request: UpdateTaskRequest,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update task

        Update a task by id. This endpoint currently only supports updating task status.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to edit the containing page or blog post and view its corresponding space.

        :param id: The ID of the task to be updated. If you don't know the task ID, use Get tasks and filter the results. (required)
        :type id: int
        :param update_task_request: (required)
        :type update_task_request: UpdateTaskRequest
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_task_serialize(
            id=id,
            update_task_request=update_task_request,
            body_format=body_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Task",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_task_serialize(
        self,
        id,
        update_task_request,
        body_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_task_request is not None:
            _body_params = update_task_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/tasks/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


