# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.abstract_page_links import AbstractPageLinks
from devopso.clients.confluence_cloud.models.blog_post_content_status import BlogPostContentStatus
from devopso.clients.confluence_cloud.models.body_bulk import BodyBulk
from devopso.clients.confluence_cloud.models.version import Version
from typing import Optional, Set
from typing_extensions import Self

class BlogPostBulk(BaseModel):
    """
    BlogPostBulk
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the blog post.")
    status: Optional[BlogPostContentStatus] = None
    title: Optional[StrictStr] = Field(default=None, description="Title of the blog post.")
    space_id: Optional[StrictStr] = Field(default=None, description="ID of the space the blog post is in.", alias="spaceId")
    author_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who created this blog post originally.", alias="authorId")
    created_at: Optional[datetime] = Field(default=None, description="Date and time when the blog post was created. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="createdAt")
    version: Optional[Version] = None
    body: Optional[BodyBulk] = None
    links: Optional[AbstractPageLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "status", "title", "spaceId", "authorId", "createdAt", "version", "body", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BlogPostBulk from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BlogPostBulk from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "spaceId": obj.get("spaceId"),
            "authorId": obj.get("authorId"),
            "createdAt": obj.get("createdAt"),
            "version": Version.from_dict(obj["version"]) if obj.get("version") is not None else None,
            "body": BodyBulk.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "_links": AbstractPageLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


