# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.versioned_entity import VersionedEntity
from typing import Optional, Set
from typing_extensions import Self

class BlogPostVersion(BaseModel):
    """
    BlogPostVersion
    """ # noqa: E501
    created_at: Optional[datetime] = Field(default=None, description="Date and time when the version was created. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="createdAt")
    message: Optional[StrictStr] = Field(default=None, description="Message associated with the current version.")
    number: Optional[StrictInt] = Field(default=None, description="The version number.")
    minor_edit: Optional[StrictBool] = Field(default=None, description="Describes if this version is a minor version. Email notifications and activity stream updates are not created for minor versions.", alias="minorEdit")
    author_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who created this version.", alias="authorId")
    blogpost: Optional[VersionedEntity] = None
    __properties: ClassVar[List[str]] = ["createdAt", "message", "number", "minorEdit", "authorId", "blogpost"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BlogPostVersion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of blogpost
        if self.blogpost:
            _dict['blogpost'] = self.blogpost.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BlogPostVersion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdAt": obj.get("createdAt"),
            "message": obj.get("message"),
            "number": obj.get("number"),
            "minorEdit": obj.get("minorEdit"),
            "authorId": obj.get("authorId"),
            "blogpost": VersionedEntity.from_dict(obj["blogpost"]) if obj.get("blogpost") is not None else None
        })
        return _obj


