# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.create_blog_post_request_body import CreateBlogPostRequestBody
from typing import Optional, Set
from typing_extensions import Self

class CreateBlogPostRequest(BaseModel):
    """
    CreateBlogPostRequest
    """ # noqa: E501
    space_id: StrictStr = Field(description="ID of the space", alias="spaceId")
    status: Optional[StrictStr] = Field(default=None, description="The status of the blog post, specifies if the blog post will be created as a new blog post or a draft")
    title: Optional[StrictStr] = Field(default=None, description="Title of the blog post, required if creating non-draft.")
    body: Optional[CreateBlogPostRequestBody] = None
    created_at: Optional[StrictStr] = Field(default=None, description="Created date of the blog post in the format of \"yyyy-MM-ddTHH:mm:ss.SSSZ\".", alias="createdAt")
    __properties: ClassVar[List[str]] = ["spaceId", "status", "title", "body", "createdAt"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['current', 'draft']):
            raise ValueError("must be one of enum values ('current', 'draft')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateBlogPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateBlogPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "spaceId": obj.get("spaceId"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "body": CreateBlogPostRequestBody.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "createdAt": obj.get("createdAt")
        })
        return _obj


