# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.create_footer_comment_model_body import CreateFooterCommentModelBody
from typing import Optional, Set
from typing_extensions import Self

class CreateFooterCommentModel(BaseModel):
    """
    CreateFooterCommentModel
    """ # noqa: E501
    blog_post_id: Optional[StrictStr] = Field(default=None, description="ID of the containing blog post, if intending to create a top level footer comment. Do not provide if creating a reply.", alias="blogPostId")
    page_id: Optional[StrictStr] = Field(default=None, description="ID of the containing page, if intending to create a top level footer comment. Do not provide if creating a reply.", alias="pageId")
    parent_comment_id: Optional[StrictStr] = Field(default=None, description="ID of the parent comment, if intending to create a reply. Do not provide if creating a top level comment.", alias="parentCommentId")
    attachment_id: Optional[StrictStr] = Field(default=None, description="ID of the attachment, if intending to create a comment against an attachment.", alias="attachmentId")
    custom_content_id: Optional[StrictStr] = Field(default=None, description="ID of the custom content, if intending to create a comment against a custom content.", alias="customContentId")
    body: Optional[CreateFooterCommentModelBody] = None
    __properties: ClassVar[List[str]] = ["blogPostId", "pageId", "parentCommentId", "attachmentId", "customContentId", "body"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateFooterCommentModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateFooterCommentModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "blogPostId": obj.get("blogPostId"),
            "pageId": obj.get("pageId"),
            "parentCommentId": obj.get("parentCommentId"),
            "attachmentId": obj.get("attachmentId"),
            "customContentId": obj.get("customContentId"),
            "body": CreateFooterCommentModelBody.from_dict(obj["body"]) if obj.get("body") is not None else None
        })
        return _obj


