# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.attachment_single_operations import AttachmentSingleOperations
from devopso.clients.confluence_cloud.models.attachment_single_versions import AttachmentSingleVersions
from devopso.clients.confluence_cloud.models.blog_post_single_likes import BlogPostSingleLikes
from devopso.clients.confluence_cloud.models.body_single import BodySingle
from devopso.clients.confluence_cloud.models.content_status import ContentStatus
from devopso.clients.confluence_cloud.models.get_attachment_by_id200_response_all_of_links import GetAttachmentById200ResponseAllOfLinks
from devopso.clients.confluence_cloud.models.inline_comment_model_properties import InlineCommentModelProperties
from devopso.clients.confluence_cloud.models.inline_comment_resolution_status import InlineCommentResolutionStatus
from devopso.clients.confluence_cloud.models.version import Version
from typing import Optional, Set
from typing_extensions import Self

class CreateInlineComment201Response(BaseModel):
    """
    CreateInlineComment201Response
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the comment.")
    status: Optional[ContentStatus] = None
    title: Optional[StrictStr] = Field(default=None, description="Title of the comment.")
    blog_post_id: Optional[StrictStr] = Field(default=None, description="ID of the blog post containing the comment if the comment is on a blog post.", alias="blogPostId")
    page_id: Optional[StrictStr] = Field(default=None, description="ID of the page containing the comment if the comment is on a page.", alias="pageId")
    parent_comment_id: Optional[StrictStr] = Field(default=None, description="ID of the parent comment if the comment is a reply.", alias="parentCommentId")
    version: Optional[Version] = None
    body: Optional[BodySingle] = None
    resolution_last_modifier_id: Optional[StrictStr] = Field(default=None, description="Atlassian Account ID of last person who modified the resolve state of the comment. Null until comment is resolved or reopened.", alias="resolutionLastModifierId")
    resolution_last_modified_at: Optional[datetime] = Field(default=None, description="Timestamp of the last modification to the comment's resolution status. Null until comment is resolved or reopened.", alias="resolutionLastModifiedAt")
    resolution_status: Optional[InlineCommentResolutionStatus] = Field(default=None, alias="resolutionStatus")
    properties: Optional[InlineCommentModelProperties] = None
    operations: Optional[AttachmentSingleOperations] = None
    likes: Optional[BlogPostSingleLikes] = None
    versions: Optional[AttachmentSingleVersions] = None
    links: Optional[GetAttachmentById200ResponseAllOfLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "status", "title", "blogPostId", "pageId", "parentCommentId", "version", "body", "resolutionLastModifierId", "resolutionLastModifiedAt", "resolutionStatus", "properties", "operations", "likes", "versions", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInlineComment201Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of properties
        if self.properties:
            _dict['properties'] = self.properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operations
        if self.operations:
            _dict['operations'] = self.operations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of likes
        if self.likes:
            _dict['likes'] = self.likes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of versions
        if self.versions:
            _dict['versions'] = self.versions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInlineComment201Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "blogPostId": obj.get("blogPostId"),
            "pageId": obj.get("pageId"),
            "parentCommentId": obj.get("parentCommentId"),
            "version": Version.from_dict(obj["version"]) if obj.get("version") is not None else None,
            "body": BodySingle.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "resolutionLastModifierId": obj.get("resolutionLastModifierId"),
            "resolutionLastModifiedAt": obj.get("resolutionLastModifiedAt"),
            "resolutionStatus": obj.get("resolutionStatus"),
            "properties": InlineCommentModelProperties.from_dict(obj["properties"]) if obj.get("properties") is not None else None,
            "operations": AttachmentSingleOperations.from_dict(obj["operations"]) if obj.get("operations") is not None else None,
            "likes": BlogPostSingleLikes.from_dict(obj["likes"]) if obj.get("likes") is not None else None,
            "versions": AttachmentSingleVersions.from_dict(obj["versions"]) if obj.get("versions") is not None else None,
            "_links": GetAttachmentById200ResponseAllOfLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


