# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateInlineCommentModelInlineCommentProperties(BaseModel):
    """
    Object describing the text to highlight on the page/blog post. Only applicable for top level inline comments (not replies) and required in that case.
    """ # noqa: E501
    text_selection: Optional[StrictStr] = Field(default=None, description="The text to highlight", alias="textSelection")
    text_selection_match_count: Optional[StrictInt] = Field(default=None, description="The number of matches for the selected text on the page (should be strictly greater than textSelectionMatchIndex)", alias="textSelectionMatchCount")
    text_selection_match_index: Optional[StrictInt] = Field(default=None, description="The match index to highlight. This is zero-based. E.g. if you have 3 occurrences of \"hello world\" on a page  and you want to highlight the second occurrence, you should pass 1 for textSelectionMatchIndex and 3 for textSelectionMatchCount.", alias="textSelectionMatchIndex")
    __properties: ClassVar[List[str]] = ["textSelection", "textSelectionMatchCount", "textSelectionMatchIndex"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInlineCommentModelInlineCommentProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInlineCommentModelInlineCommentProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "textSelection": obj.get("textSelection"),
            "textSelectionMatchCount": obj.get("textSelectionMatchCount"),
            "textSelectionMatchIndex": obj.get("textSelectionMatchIndex")
        })
        return _obj


