# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.page_body_write import PageBodyWrite
from typing import Optional, Set
from typing_extensions import Self

class CreatePageRequest(BaseModel):
    """
    CreatePageRequest
    """ # noqa: E501
    space_id: StrictStr = Field(description="ID of the space.", alias="spaceId")
    status: Optional[StrictStr] = Field(default=None, description="The status of the page, published or draft.")
    title: Optional[StrictStr] = Field(default=None, description="Title of the page, required if page status is not draft.")
    parent_id: Optional[StrictStr] = Field(default=None, description="The parent content ID of the page. If the `root-level` query parameter is set to false and a value is  not supplied for this parameter, then the space homepage's ID will be used. If the `root-level` query  parameter is set to true, then a value may not be supplied for this parameter.", alias="parentId")
    body: Optional[PageBodyWrite] = None
    subtype: Optional[StrictStr] = Field(default=None, description="The subtype of the page. Provide the subtype live to create a live doc or no subtype to create a page.")
    __properties: ClassVar[List[str]] = ["spaceId", "status", "title", "parentId", "body", "subtype"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['current', 'draft']):
            raise ValueError("must be one of enum values ('current', 'draft')")
        return value

    @field_validator('subtype')
    def subtype_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['live']):
            raise ValueError("must be one of enum values ('live')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePageRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePageRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "spaceId": obj.get("spaceId"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "parentId": obj.get("parentId"),
            "body": PageBodyWrite.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "subtype": obj.get("subtype")
        })
        return _obj


