# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.create_space_request_description import CreateSpaceRequestDescription
from devopso.clients.confluence_cloud.models.create_space_request_role_assignments_inner import CreateSpaceRequestRoleAssignmentsInner
from typing import Optional, Set
from typing_extensions import Self

class CreateSpaceRequest(BaseModel):
    """
    CreateSpaceRequest
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the space to be created.")
    key: Optional[StrictStr] = Field(default=None, description="The key for the new space. See [Space Keys](https://support.atlassian.com/confluence-cloud/docs/create-a-space/). If the key property is not provided, the alias property is required to be used instead.")
    alias: Optional[StrictStr] = Field(default=None, description="This field will be used as the new identifier for the space in confluence page URLs. If the alias property is not provided, the key property is required to be used instead. Maximum 255 alphanumeric characters in length.")
    description: Optional[CreateSpaceRequestDescription] = None
    role_assignments: Optional[List[CreateSpaceRequestRoleAssignmentsInner]] = Field(default=None, alias="roleAssignments")
    copy_space_access_configuration: Optional[StrictInt] = Field(default=None, description="The id of the space to copy the space access configuration from.", alias="copySpaceAccessConfiguration")
    create_private_space: Optional[StrictBool] = Field(default=None, description="Whether to create the space as private.", alias="createPrivateSpace")
    template_key: Optional[StrictStr] = Field(default=None, description="The key of the template to use.", alias="templateKey")
    __properties: ClassVar[List[str]] = ["name", "key", "alias", "description", "roleAssignments", "copySpaceAccessConfiguration", "createPrivateSpace", "templateKey"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSpaceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['description'] = self.description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in role_assignments (list)
        _items = []
        if self.role_assignments:
            for _item_role_assignments in self.role_assignments:
                if _item_role_assignments:
                    _items.append(_item_role_assignments.to_dict())
            _dict['roleAssignments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSpaceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "key": obj.get("key"),
            "alias": obj.get("alias"),
            "description": CreateSpaceRequestDescription.from_dict(obj["description"]) if obj.get("description") is not None else None,
            "roleAssignments": [CreateSpaceRequestRoleAssignmentsInner.from_dict(_item) for _item in obj["roleAssignments"]] if obj.get("roleAssignments") is not None else None,
            "copySpaceAccessConfiguration": obj.get("copySpaceAccessConfiguration"),
            "createPrivateSpace": obj.get("createPrivateSpace"),
            "templateKey": obj.get("templateKey")
        })
        return _obj


