# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateWhiteboardRequest(BaseModel):
    """
    CreateWhiteboardRequest
    """ # noqa: E501
    space_id: StrictStr = Field(description="ID of the space.", alias="spaceId")
    title: Optional[StrictStr] = Field(default=None, description="Title of the whiteboard.")
    parent_id: Optional[StrictStr] = Field(default=None, description="The parent content ID of the whiteboard.", alias="parentId")
    template_key: Optional[StrictStr] = Field(default=None, description="Providing a template key will add that template to the new whiteboard.", alias="templateKey")
    locale: Optional[StrictStr] = Field(default=None, description="If templateKey is provided, locale will decide which language the template will be created with. If locale is omitted, the user's locale will be used.")
    __properties: ClassVar[List[str]] = ["spaceId", "title", "parentId", "templateKey", "locale"]

    @field_validator('template_key')
    def template_key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['2x2-prioritization', '4ls-retro', 'annual-calendar', 'brainwriting', 'concept-map', 'crazy-8s', 'daily-sync', 'disruptive-brainstorm', 'dot-voting', 'elevator-pitch', 'flow-chart', 'gap-analysis', 'ice-breakers', 'incident-postmortem', 'journey-mapping-kit', 'kanban-board', 'lean-coffee', 'network-of-teams', 'org-chart', 'pi-planning', 'prioritization', 'prioritization-experiment', 'product-roadmap', 'product-vision-board', 'rice', 'sailboat-retro', 'service-blueprint', 'simple-retrospective', 'sprint-planning', 'sticky-note-pack', 'swimlanes', 'team-formation-guide', 'timeline', 'timeline-workflow', 'user-story-map', 'workflow', 'vision-board', 'venn-diagram', 'storyboard', 'action-plan', 'root-cause-analysis', 'executive-summary', 'stakeholder-mapping', 'annual-calendar-2025-2026', 'health-monitor', 'okr-planning', 'swot-analysis', 'poker-planning', 'fishbone-diagram', 'risk-assessment', 'bounded-context', 'hopes-and-fears', 'swimlane-vertical']):
            raise ValueError("must be one of enum values ('2x2-prioritization', '4ls-retro', 'annual-calendar', 'brainwriting', 'concept-map', 'crazy-8s', 'daily-sync', 'disruptive-brainstorm', 'dot-voting', 'elevator-pitch', 'flow-chart', 'gap-analysis', 'ice-breakers', 'incident-postmortem', 'journey-mapping-kit', 'kanban-board', 'lean-coffee', 'network-of-teams', 'org-chart', 'pi-planning', 'prioritization', 'prioritization-experiment', 'product-roadmap', 'product-vision-board', 'rice', 'sailboat-retro', 'service-blueprint', 'simple-retrospective', 'sprint-planning', 'sticky-note-pack', 'swimlanes', 'team-formation-guide', 'timeline', 'timeline-workflow', 'user-story-map', 'workflow', 'vision-board', 'venn-diagram', 'storyboard', 'action-plan', 'root-cause-analysis', 'executive-summary', 'stakeholder-mapping', 'annual-calendar-2025-2026', 'health-monitor', 'okr-planning', 'swot-analysis', 'poker-planning', 'fishbone-diagram', 'risk-assessment', 'bounded-context', 'hopes-and-fears', 'swimlane-vertical')")
        return value

    @field_validator('locale')
    def locale_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['de-DE', 'cs-CZ', 'ko-KR', 'fr-FR', 'it-IT', 'ja-JP', 'nl-NL', 'nb-NO', 'da-DK', 'sv-SE', 'fi-FI', 'ru-RU', 'pl-PL', 'tr-TR', 'hu-HU', 'en-GB', 'en-US', 'pt-BR', 'zh-CN', 'zh-TW', 'es-ES']):
            raise ValueError("must be one of enum values ('de-DE', 'cs-CZ', 'ko-KR', 'fr-FR', 'it-IT', 'ja-JP', 'nl-NL', 'nb-NO', 'da-DK', 'sv-SE', 'fi-FI', 'ru-RU', 'pl-PL', 'tr-TR', 'hu-HU', 'en-GB', 'en-US', 'pt-BR', 'zh-CN', 'zh-TW', 'es-ES')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateWhiteboardRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateWhiteboardRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "spaceId": obj.get("spaceId"),
            "title": obj.get("title"),
            "parentId": obj.get("parentId"),
            "templateKey": obj.get("templateKey"),
            "locale": obj.get("locale")
        })
        return _obj


