# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.content_status import ContentStatus
from devopso.clients.confluence_cloud.models.custom_content_body_bulk import CustomContentBodyBulk
from devopso.clients.confluence_cloud.models.custom_content_links import CustomContentLinks
from devopso.clients.confluence_cloud.models.version import Version
from typing import Optional, Set
from typing_extensions import Self

class CustomContentBulk(BaseModel):
    """
    CustomContentBulk
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the custom content.")
    type: Optional[StrictStr] = Field(default=None, description="The type of custom content.")
    status: Optional[ContentStatus] = None
    title: Optional[StrictStr] = Field(default=None, description="Title of the custom content.")
    space_id: Optional[StrictStr] = Field(default=None, description="ID of the space the custom content is in.  Note: This is always returned, regardless of if the custom content has a container that is a space.", alias="spaceId")
    page_id: Optional[StrictStr] = Field(default=None, description="ID of the containing page.  Note: This is only returned if the custom content has a container that is a page.", alias="pageId")
    blog_post_id: Optional[StrictStr] = Field(default=None, description="ID of the containing blog post.  Note: This is only returned if the custom content has a container that is a blog post.", alias="blogPostId")
    custom_content_id: Optional[StrictStr] = Field(default=None, description="ID of the containing custom content.  Note: This is only returned if the custom content has a container that is custom content.", alias="customContentId")
    author_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who created this custom content originally.", alias="authorId")
    created_at: Optional[datetime] = Field(default=None, description="Date and time when the custom content was created. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="createdAt")
    version: Optional[Version] = None
    body: Optional[CustomContentBodyBulk] = None
    links: Optional[CustomContentLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "type", "status", "title", "spaceId", "pageId", "blogPostId", "customContentId", "authorId", "createdAt", "version", "body", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomContentBulk from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomContentBulk from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "spaceId": obj.get("spaceId"),
            "pageId": obj.get("pageId"),
            "blogPostId": obj.get("blogPostId"),
            "customContentId": obj.get("customContentId"),
            "authorId": obj.get("authorId"),
            "createdAt": obj.get("createdAt"),
            "version": Version.from_dict(obj["version"]) if obj.get("version") is not None else None,
            "body": CustomContentBodyBulk.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "_links": CustomContentLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


