# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.data_policy_space_data_policy import DataPolicySpaceDataPolicy
from devopso.clients.confluence_cloud.models.space_description import SpaceDescription
from devopso.clients.confluence_cloud.models.space_icon import SpaceIcon
from devopso.clients.confluence_cloud.models.space_links import SpaceLinks
from typing import Optional, Set
from typing_extensions import Self

class DataPolicySpace(BaseModel):
    """
    DataPolicySpace
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the space.")
    key: Optional[StrictStr] = Field(default=None, description="Key of the space.")
    name: Optional[StrictStr] = Field(default=None, description="Name of the space.")
    description: Optional[SpaceDescription] = None
    data_policy: Optional[DataPolicySpaceDataPolicy] = Field(default=None, alias="dataPolicy")
    icon: Optional[SpaceIcon] = None
    links: Optional[SpaceLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "key", "name", "description", "dataPolicy", "icon", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataPolicySpace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['description'] = self.description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_policy
        if self.data_policy:
            _dict['dataPolicy'] = self.data_policy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of icon
        if self.icon:
            _dict['icon'] = self.icon.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataPolicySpace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "description": SpaceDescription.from_dict(obj["description"]) if obj.get("description") is not None else None,
            "dataPolicy": DataPolicySpaceDataPolicy.from_dict(obj["dataPolicy"]) if obj.get("dataPolicy") is not None else None,
            "icon": SpaceIcon.from_dict(obj["icon"]) if obj.get("icon") is not None else None,
            "_links": SpaceLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


