# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.attachment_single_labels import AttachmentSingleLabels
from devopso.clients.confluence_cloud.models.attachment_single_operations import AttachmentSingleOperations
from devopso.clients.confluence_cloud.models.attachment_single_properties import AttachmentSingleProperties
from devopso.clients.confluence_cloud.models.attachment_single_versions import AttachmentSingleVersions
from devopso.clients.confluence_cloud.models.content_status import ContentStatus
from devopso.clients.confluence_cloud.models.get_attachment_by_id200_response_all_of_links import GetAttachmentById200ResponseAllOfLinks
from devopso.clients.confluence_cloud.models.version import Version
from typing import Optional, Set
from typing_extensions import Self

class GetAttachmentById200Response(BaseModel):
    """
    GetAttachmentById200Response
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the attachment.")
    status: Optional[ContentStatus] = None
    title: Optional[StrictStr] = Field(default=None, description="Title of the comment.")
    created_at: Optional[datetime] = Field(default=None, description="Date and time when the attachment was created. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="createdAt")
    page_id: Optional[StrictStr] = Field(default=None, description="ID of the containing page.  Note: This is only returned if the attachment has a container that is a page.", alias="pageId")
    blog_post_id: Optional[StrictStr] = Field(default=None, description="ID of the containing blog post.  Note: This is only returned if the attachment has a container that is a blog post.", alias="blogPostId")
    custom_content_id: Optional[StrictStr] = Field(default=None, description="ID of the containing custom content.  Note: This is only returned if the attachment has a container that is custom content.", alias="customContentId")
    media_type: Optional[StrictStr] = Field(default=None, description="Media Type for the attachment.", alias="mediaType")
    media_type_description: Optional[StrictStr] = Field(default=None, description="Media Type description for the attachment.", alias="mediaTypeDescription")
    comment: Optional[StrictStr] = Field(default=None, description="Comment for the attachment.")
    file_id: Optional[StrictStr] = Field(default=None, description="File ID of the attachment. This is the ID referenced in `atlas_doc_format` bodies and is distinct from the attachment ID.", alias="fileId")
    file_size: Optional[StrictInt] = Field(default=None, description="File size of the attachment.", alias="fileSize")
    webui_link: Optional[StrictStr] = Field(default=None, description="WebUI link of the attachment.", alias="webuiLink")
    download_link: Optional[StrictStr] = Field(default=None, description="Download link of the attachment.", alias="downloadLink")
    version: Optional[Version] = None
    labels: Optional[AttachmentSingleLabels] = None
    properties: Optional[AttachmentSingleProperties] = None
    operations: Optional[AttachmentSingleOperations] = None
    versions: Optional[AttachmentSingleVersions] = None
    links: Optional[GetAttachmentById200ResponseAllOfLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "status", "title", "createdAt", "pageId", "blogPostId", "customContentId", "mediaType", "mediaTypeDescription", "comment", "fileId", "fileSize", "webuiLink", "downloadLink", "version", "labels", "properties", "operations", "versions", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAttachmentById200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of labels
        if self.labels:
            _dict['labels'] = self.labels.to_dict()
        # override the default output from pydantic by calling `to_dict()` of properties
        if self.properties:
            _dict['properties'] = self.properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operations
        if self.operations:
            _dict['operations'] = self.operations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of versions
        if self.versions:
            _dict['versions'] = self.versions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAttachmentById200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "createdAt": obj.get("createdAt"),
            "pageId": obj.get("pageId"),
            "blogPostId": obj.get("blogPostId"),
            "customContentId": obj.get("customContentId"),
            "mediaType": obj.get("mediaType"),
            "mediaTypeDescription": obj.get("mediaTypeDescription"),
            "comment": obj.get("comment"),
            "fileId": obj.get("fileId"),
            "fileSize": obj.get("fileSize"),
            "webuiLink": obj.get("webuiLink"),
            "downloadLink": obj.get("downloadLink"),
            "version": Version.from_dict(obj["version"]) if obj.get("version") is not None else None,
            "labels": AttachmentSingleLabels.from_dict(obj["labels"]) if obj.get("labels") is not None else None,
            "properties": AttachmentSingleProperties.from_dict(obj["properties"]) if obj.get("properties") is not None else None,
            "operations": AttachmentSingleOperations.from_dict(obj["operations"]) if obj.get("operations") is not None else None,
            "versions": AttachmentSingleVersions.from_dict(obj["versions"]) if obj.get("versions") is not None else None,
            "_links": GetAttachmentById200ResponseAllOfLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


