# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.get_attachment_by_id200_response_all_of_links import GetAttachmentById200ResponseAllOfLinks
from devopso.clients.confluence_cloud.models.role_type import RoleType
from typing import Optional, Set
from typing_extensions import Self

class GetSpaceRolesById200Response(BaseModel):
    """
    GetSpaceRolesById200Response
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The identifier for the space role.")
    type: Optional[RoleType] = None
    name: Optional[StrictStr] = Field(default=None, description="The name for the space role.")
    description: Optional[StrictStr] = Field(default=None, description="The description for the space role’s usage.")
    space_permissions: Optional[List[StrictStr]] = Field(default=None, description="The space permissions the space role is comprised of.", alias="spacePermissions")
    links: Optional[GetAttachmentById200ResponseAllOfLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "type", "name", "description", "spacePermissions", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetSpaceRolesById200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetSpaceRolesById200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "spacePermissions": obj.get("spacePermissions"),
            "_links": GetAttachmentById200ResponseAllOfLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


