# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.abstract_page_links import AbstractPageLinks
from devopso.clients.confluence_cloud.models.body_bulk import BodyBulk
from devopso.clients.confluence_cloud.models.content_status import ContentStatus
from devopso.clients.confluence_cloud.models.parent_content_type import ParentContentType
from devopso.clients.confluence_cloud.models.version import Version
from typing import Optional, Set
from typing_extensions import Self

class PageBulk(BaseModel):
    """
    PageBulk
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the page.")
    status: Optional[ContentStatus] = None
    title: Optional[StrictStr] = Field(default=None, description="Title of the page.")
    space_id: Optional[StrictStr] = Field(default=None, description="ID of the space the page is in.", alias="spaceId")
    parent_id: Optional[StrictStr] = Field(default=None, description="ID of the parent page, or null if there is no parent page.", alias="parentId")
    parent_type: Optional[ParentContentType] = Field(default=None, alias="parentType")
    position: Optional[StrictInt] = Field(default=None, description="Position of child page within the given parent page tree.")
    author_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who created this page originally.", alias="authorId")
    owner_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who owns this page.", alias="ownerId")
    last_owner_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who owned this page previously, or null if there is no previous owner.", alias="lastOwnerId")
    subtype: Optional[StrictStr] = Field(default=None, description="The subtype of the page.")
    created_at: Optional[datetime] = Field(default=None, description="Date and time when the page was created. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="createdAt")
    version: Optional[Version] = None
    body: Optional[BodyBulk] = None
    links: Optional[AbstractPageLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "status", "title", "spaceId", "parentId", "parentType", "position", "authorId", "ownerId", "lastOwnerId", "subtype", "createdAt", "version", "body", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PageBulk from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        # set to None if position (nullable) is None
        # and model_fields_set contains the field
        if self.position is None and "position" in self.model_fields_set:
            _dict['position'] = None

        # set to None if owner_id (nullable) is None
        # and model_fields_set contains the field
        if self.owner_id is None and "owner_id" in self.model_fields_set:
            _dict['ownerId'] = None

        # set to None if last_owner_id (nullable) is None
        # and model_fields_set contains the field
        if self.last_owner_id is None and "last_owner_id" in self.model_fields_set:
            _dict['lastOwnerId'] = None

        # set to None if subtype (nullable) is None
        # and model_fields_set contains the field
        if self.subtype is None and "subtype" in self.model_fields_set:
            _dict['subtype'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PageBulk from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "spaceId": obj.get("spaceId"),
            "parentId": obj.get("parentId"),
            "parentType": obj.get("parentType"),
            "position": obj.get("position"),
            "authorId": obj.get("authorId"),
            "ownerId": obj.get("ownerId"),
            "lastOwnerId": obj.get("lastOwnerId"),
            "subtype": obj.get("subtype"),
            "createdAt": obj.get("createdAt"),
            "version": Version.from_dict(obj["version"]) if obj.get("version") is not None else None,
            "body": BodyBulk.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "_links": AbstractPageLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


