# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.abstract_page_links import AbstractPageLinks
from devopso.clients.confluence_cloud.models.attachment_single_labels import AttachmentSingleLabels
from devopso.clients.confluence_cloud.models.attachment_single_operations import AttachmentSingleOperations
from devopso.clients.confluence_cloud.models.attachment_single_properties import AttachmentSingleProperties
from devopso.clients.confluence_cloud.models.attachment_single_versions import AttachmentSingleVersions
from devopso.clients.confluence_cloud.models.blog_post_single_likes import BlogPostSingleLikes
from devopso.clients.confluence_cloud.models.body_single import BodySingle
from devopso.clients.confluence_cloud.models.content_status import ContentStatus
from devopso.clients.confluence_cloud.models.parent_content_type import ParentContentType
from devopso.clients.confluence_cloud.models.version import Version
from typing import Optional, Set
from typing_extensions import Self

class PageSingle(BaseModel):
    """
    PageSingle
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the page.")
    status: Optional[ContentStatus] = None
    title: Optional[StrictStr] = Field(default=None, description="Title of the page.")
    space_id: Optional[StrictStr] = Field(default=None, description="ID of the space the page is in.", alias="spaceId")
    parent_id: Optional[StrictStr] = Field(default=None, description="ID of the parent page, or null if there is no parent page.", alias="parentId")
    parent_type: Optional[ParentContentType] = Field(default=None, alias="parentType")
    position: Optional[StrictInt] = Field(default=None, description="Position of child page within the given parent page tree.")
    author_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who created this page originally.", alias="authorId")
    owner_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who owns this page.", alias="ownerId")
    last_owner_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who owned this page previously, or null if there is no previous owner.", alias="lastOwnerId")
    created_at: Optional[datetime] = Field(default=None, description="Date and time when the page was created. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="createdAt")
    version: Optional[Version] = None
    body: Optional[BodySingle] = None
    labels: Optional[AttachmentSingleLabels] = None
    properties: Optional[AttachmentSingleProperties] = None
    operations: Optional[AttachmentSingleOperations] = None
    likes: Optional[BlogPostSingleLikes] = None
    versions: Optional[AttachmentSingleVersions] = None
    is_favorited_by_current_user: Optional[StrictBool] = Field(default=None, description="Whether the page has been favorited by the current user.", alias="isFavoritedByCurrentUser")
    links: Optional[AbstractPageLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "status", "title", "spaceId", "parentId", "parentType", "position", "authorId", "ownerId", "lastOwnerId", "createdAt", "version", "body", "labels", "properties", "operations", "likes", "versions", "isFavoritedByCurrentUser", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PageSingle from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of labels
        if self.labels:
            _dict['labels'] = self.labels.to_dict()
        # override the default output from pydantic by calling `to_dict()` of properties
        if self.properties:
            _dict['properties'] = self.properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operations
        if self.operations:
            _dict['operations'] = self.operations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of likes
        if self.likes:
            _dict['likes'] = self.likes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of versions
        if self.versions:
            _dict['versions'] = self.versions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        # set to None if position (nullable) is None
        # and model_fields_set contains the field
        if self.position is None and "position" in self.model_fields_set:
            _dict['position'] = None

        # set to None if owner_id (nullable) is None
        # and model_fields_set contains the field
        if self.owner_id is None and "owner_id" in self.model_fields_set:
            _dict['ownerId'] = None

        # set to None if last_owner_id (nullable) is None
        # and model_fields_set contains the field
        if self.last_owner_id is None and "last_owner_id" in self.model_fields_set:
            _dict['lastOwnerId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PageSingle from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "spaceId": obj.get("spaceId"),
            "parentId": obj.get("parentId"),
            "parentType": obj.get("parentType"),
            "position": obj.get("position"),
            "authorId": obj.get("authorId"),
            "ownerId": obj.get("ownerId"),
            "lastOwnerId": obj.get("lastOwnerId"),
            "createdAt": obj.get("createdAt"),
            "version": Version.from_dict(obj["version"]) if obj.get("version") is not None else None,
            "body": BodySingle.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "labels": AttachmentSingleLabels.from_dict(obj["labels"]) if obj.get("labels") is not None else None,
            "properties": AttachmentSingleProperties.from_dict(obj["properties"]) if obj.get("properties") is not None else None,
            "operations": AttachmentSingleOperations.from_dict(obj["operations"]) if obj.get("operations") is not None else None,
            "likes": BlogPostSingleLikes.from_dict(obj["likes"]) if obj.get("likes") is not None else None,
            "versions": AttachmentSingleVersions.from_dict(obj["versions"]) if obj.get("versions") is not None else None,
            "isFavoritedByCurrentUser": obj.get("isFavoritedByCurrentUser"),
            "_links": AbstractPageLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


