# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class RedactionPointer(BaseModel):
    """
    RedactionPointer
    """ # noqa: E501
    pointer: StrictStr = Field(description="JSON pointer indicating the exact location within the content structure  where redaction should be applied. Points to the text node containing the content to redact. ")
    var_from: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Starting character index (zero-based) within the target text where redaction begins. ", alias="from")
    to: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Ending character index (zero-based) within the target text where redaction ends (exclusive). Must be greater than or equal to 'from' value. ")
    reason: Optional[StrictStr] = Field(default=None, description="Optional human-readable reason for the redaction. Used for audit trails and compliance documentation. ")
    __properties: ClassVar[List[str]] = ["pointer", "from", "to", "reason"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RedactionPointer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if reason (nullable) is None
        # and model_fields_set contains the field
        if self.reason is None and "reason" in self.model_fields_set:
            _dict['reason'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RedactionPointer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pointer": obj.get("pointer"),
            "from": obj.get("from"),
            "to": obj.get("to"),
            "reason": obj.get("reason")
        })
        return _obj


