# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.space_property_version import SpacePropertyVersion
from typing import Optional, Set
from typing_extensions import Self

class SpaceProperty(BaseModel):
    """
    SpaceProperty
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the space property.")
    key: Optional[StrictStr] = Field(default=None, description="Key of the space property.")
    value: Optional[Any] = Field(default=None, description="Value of the space property.")
    created_at: Optional[datetime] = Field(default=None, description="RFC3339 compliant date time at which the property was created.", alias="createdAt")
    created_by: Optional[StrictStr] = Field(default=None, description="Atlassian account ID of the user that created the space property.", alias="createdBy")
    version: Optional[SpacePropertyVersion] = None
    __properties: ClassVar[List[str]] = ["id", "key", "value", "createdAt", "createdBy", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpaceProperty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict['value'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpaceProperty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "key": obj.get("key"),
            "value": obj.get("value"),
            "createdAt": obj.get("createdAt"),
            "createdBy": obj.get("createdBy"),
            "version": SpacePropertyVersion.from_dict(obj["version"]) if obj.get("version") is not None else None
        })
        return _obj


