# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.attachment_single_labels import AttachmentSingleLabels
from devopso.clients.confluence_cloud.models.attachment_single_operations import AttachmentSingleOperations
from devopso.clients.confluence_cloud.models.space_description import SpaceDescription
from devopso.clients.confluence_cloud.models.space_icon import SpaceIcon
from devopso.clients.confluence_cloud.models.space_links import SpaceLinks
from devopso.clients.confluence_cloud.models.space_single_permissions import SpaceSinglePermissions
from devopso.clients.confluence_cloud.models.space_single_properties import SpaceSingleProperties
from devopso.clients.confluence_cloud.models.space_status import SpaceStatus
from devopso.clients.confluence_cloud.models.space_type import SpaceType
from typing import Optional, Set
from typing_extensions import Self

class SpaceSingle(BaseModel):
    """
    SpaceSingle
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the space.")
    key: Optional[StrictStr] = Field(default=None, description="Key of the space.")
    name: Optional[StrictStr] = Field(default=None, description="Name of the space.")
    type: Optional[SpaceType] = None
    status: Optional[SpaceStatus] = None
    author_id: Optional[StrictStr] = Field(default=None, description="The account ID of the user who created this space originally.", alias="authorId")
    created_at: Optional[datetime] = Field(default=None, description="Date and time when the space was created. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="createdAt")
    homepage_id: Optional[StrictStr] = Field(default=None, description="ID of the space's homepage.", alias="homepageId")
    description: Optional[SpaceDescription] = None
    icon: Optional[SpaceIcon] = None
    labels: Optional[AttachmentSingleLabels] = None
    properties: Optional[SpaceSingleProperties] = None
    operations: Optional[AttachmentSingleOperations] = None
    permissions: Optional[SpaceSinglePermissions] = None
    links: Optional[SpaceLinks] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["id", "key", "name", "type", "status", "authorId", "createdAt", "homepageId", "description", "icon", "labels", "properties", "operations", "permissions", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpaceSingle from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['description'] = self.description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of icon
        if self.icon:
            _dict['icon'] = self.icon.to_dict()
        # override the default output from pydantic by calling `to_dict()` of labels
        if self.labels:
            _dict['labels'] = self.labels.to_dict()
        # override the default output from pydantic by calling `to_dict()` of properties
        if self.properties:
            _dict['properties'] = self.properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operations
        if self.operations:
            _dict['operations'] = self.operations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpaceSingle from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "authorId": obj.get("authorId"),
            "createdAt": obj.get("createdAt"),
            "homepageId": obj.get("homepageId"),
            "description": SpaceDescription.from_dict(obj["description"]) if obj.get("description") is not None else None,
            "icon": SpaceIcon.from_dict(obj["icon"]) if obj.get("icon") is not None else None,
            "labels": AttachmentSingleLabels.from_dict(obj["labels"]) if obj.get("labels") is not None else None,
            "properties": SpaceSingleProperties.from_dict(obj["properties"]) if obj.get("properties") is not None else None,
            "operations": AttachmentSingleOperations.from_dict(obj["operations"]) if obj.get("operations") is not None else None,
            "permissions": SpaceSinglePermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "_links": SpaceLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None
        })
        return _obj


