# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.create_custom_content_request_body import CreateCustomContentRequestBody
from devopso.clients.confluence_cloud.models.update_custom_content_request_version import UpdateCustomContentRequestVersion
from typing import Optional, Set
from typing_extensions import Self

class UpdateCustomContentRequest(BaseModel):
    """
    UpdateCustomContentRequest
    """ # noqa: E501
    id: StrictStr = Field(description="Id of custom content.")
    type: StrictStr = Field(description="Type of custom content.")
    status: StrictStr = Field(description="The status of the custom content.")
    space_id: Optional[StrictStr] = Field(default=None, description="ID of the containing space (must be the same as the spaceId of the space the custom content was created in).", alias="spaceId")
    page_id: Optional[StrictStr] = Field(default=None, description="ID of the containing page.", alias="pageId")
    blog_post_id: Optional[StrictStr] = Field(default=None, description="ID of the containing Blog Post.", alias="blogPostId")
    custom_content_id: Optional[StrictStr] = Field(default=None, description="ID of the containing custom content.", alias="customContentId")
    title: StrictStr = Field(description="Title of the custom content.")
    body: CreateCustomContentRequestBody
    version: UpdateCustomContentRequestVersion
    __properties: ClassVar[List[str]] = ["id", "type", "status", "spaceId", "pageId", "blogPostId", "customContentId", "title", "body", "version"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['current']):
            raise ValueError("must be one of enum values ('current')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateCustomContentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateCustomContentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "spaceId": obj.get("spaceId"),
            "pageId": obj.get("pageId"),
            "blogPostId": obj.get("blogPostId"),
            "customContentId": obj.get("customContentId"),
            "title": obj.get("title"),
            "body": CreateCustomContentRequestBody.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "version": UpdateCustomContentRequestVersion.from_dict(obj["version"]) if obj.get("version") is not None else None
        })
        return _obj


