# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.confluence_cloud.models.page_body_write import PageBodyWrite
from devopso.clients.confluence_cloud.models.update_page_request_version import UpdatePageRequestVersion
from typing import Optional, Set
from typing_extensions import Self

class UpdatePageRequest(BaseModel):
    """
    UpdatePageRequest
    """ # noqa: E501
    id: StrictStr = Field(description="Id of the page.")
    status: StrictStr = Field(description="The updated status of the page.  Note, if you change the status of a page from 'current' to 'draft' and it has an existing draft, the existing draft will be deleted in favor of the updated draft. Additionally, this endpoint can be used to restore a 'trashed' or 'deleted' page to 'current' status. For restoration, page contents will not be updated and only the page status will be changed.")
    title: StrictStr = Field(description="Title of the page.")
    space_id: Optional[Any] = Field(default=None, description="ID of the containing space.  This currently **does not support moving the page to a different space**.", alias="spaceId")
    parent_id: Optional[Any] = Field(default=None, description="ID of the parent content.  This allows the page to be moved under a different parent within the same space.", alias="parentId")
    owner_id: Optional[Any] = Field(default=None, description="Account ID of the page owner.  This allows page ownership to be transferred to another user.", alias="ownerId")
    body: PageBodyWrite
    version: UpdatePageRequestVersion
    __properties: ClassVar[List[str]] = ["id", "status", "title", "spaceId", "parentId", "ownerId", "body", "version"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['current', 'draft']):
            raise ValueError("must be one of enum values ('current', 'draft')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatePageRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # set to None if space_id (nullable) is None
        # and model_fields_set contains the field
        if self.space_id is None and "space_id" in self.model_fields_set:
            _dict['spaceId'] = None

        # set to None if parent_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_id is None and "parent_id" in self.model_fields_set:
            _dict['parentId'] = None

        # set to None if owner_id (nullable) is None
        # and model_fields_set contains the field
        if self.owner_id is None and "owner_id" in self.model_fields_set:
            _dict['ownerId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatePageRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "spaceId": obj.get("spaceId"),
            "parentId": obj.get("parentId"),
            "ownerId": obj.get("ownerId"),
            "body": PageBodyWrite.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "version": UpdatePageRequestVersion.from_dict(obj["version"]) if obj.get("version") is not None else None
        })
        return _obj


