# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateTaskRequest(BaseModel):
    """
    UpdateTaskRequest
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the task.")
    local_id: Optional[StrictStr] = Field(default=None, description="Local ID of the task. This ID is local to the corresponding page or blog post.", alias="localId")
    space_id: Optional[StrictStr] = Field(default=None, description="ID of the space the task is in.", alias="spaceId")
    page_id: Optional[StrictStr] = Field(default=None, description="ID of the page the task is in.", alias="pageId")
    blog_post_id: Optional[StrictStr] = Field(default=None, description="ID of the blog post the task is in.", alias="blogPostId")
    status: StrictStr = Field(description="Status of the task.")
    created_by: Optional[StrictStr] = Field(default=None, description="Account ID of the user who created this task.", alias="createdBy")
    assigned_to: Optional[StrictStr] = Field(default=None, description="Account ID of the user to whom this task is assigned.", alias="assignedTo")
    completed_by: Optional[StrictStr] = Field(default=None, description="Account ID of the user who completed this task.", alias="completedBy")
    created_at: Optional[datetime] = Field(default=None, description="Date and time when the task was created. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, description="Date and time when the task was updated. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="updatedAt")
    due_at: Optional[datetime] = Field(default=None, description="Date and time when the task is due. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="dueAt")
    completed_at: Optional[datetime] = Field(default=None, description="Date and time when the task was completed. In format \"YYYY-MM-DDTHH:mm:ss.sssZ\".", alias="completedAt")
    __properties: ClassVar[List[str]] = ["id", "localId", "spaceId", "pageId", "blogPostId", "status", "createdBy", "assignedTo", "completedBy", "createdAt", "updatedAt", "dueAt", "completedAt"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['complete', 'incomplete']):
            raise ValueError("must be one of enum values ('complete', 'incomplete')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateTaskRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateTaskRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "localId": obj.get("localId"),
            "spaceId": obj.get("spaceId"),
            "pageId": obj.get("pageId"),
            "blogPostId": obj.get("blogPostId"),
            "status": obj.get("status"),
            "createdBy": obj.get("createdBy"),
            "assignedTo": obj.get("assignedTo"),
            "completedBy": obj.get("completedBy"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "dueAt": obj.get("dueAt"),
            "completedAt": obj.get("completedAt")
        })
        return _obj


