# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.organization_secret_scanning_alert import OrganizationSecretScanningAlert
from devopso.clients.github.models.secret_scanning_alert import SecretScanningAlert
from devopso.clients.github.models.secret_scanning_create_push_protection_bypass_request import SecretScanningCreatePushProtectionBypassRequest
from devopso.clients.github.models.secret_scanning_location import SecretScanningLocation
from devopso.clients.github.models.secret_scanning_pattern_configuration import SecretScanningPatternConfiguration
from devopso.clients.github.models.secret_scanning_push_protection_bypass import SecretScanningPushProtectionBypass
from devopso.clients.github.models.secret_scanning_scan_history import SecretScanningScanHistory
from devopso.clients.github.models.secret_scanning_update_alert_request import SecretScanningUpdateAlertRequest
from devopso.clients.github.models.secret_scanning_update_org_pattern_configs200_response import SecretScanningUpdateOrgPatternConfigs200Response
from devopso.clients.github.models.secret_scanning_update_org_pattern_configs_request import SecretScanningUpdateOrgPatternConfigsRequest

from devopso.clients.github.api_client import ApiClient, RequestSerialized
from devopso.clients.github.api_response import ApiResponse
from devopso.clients.github.rest import RESTResponseType


class SecretScanningApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def secret_scanning_create_push_protection_bypass(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        secret_scanning_create_push_protection_bypass_request: SecretScanningCreatePushProtectionBypassRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SecretScanningPushProtectionBypass:
        """Create a push protection bypass

        Creates a bypass for a previously push protected secret.  The authenticated user must be the original author of the committed secret.  OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param secret_scanning_create_push_protection_bypass_request: (required)
        :type secret_scanning_create_push_protection_bypass_request: SecretScanningCreatePushProtectionBypassRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_create_push_protection_bypass_serialize(
            owner=owner,
            repo=repo,
            secret_scanning_create_push_protection_bypass_request=secret_scanning_create_push_protection_bypass_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningPushProtectionBypass",
            '403': None,
            '404': None,
            '422': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_create_push_protection_bypass_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        secret_scanning_create_push_protection_bypass_request: SecretScanningCreatePushProtectionBypassRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SecretScanningPushProtectionBypass]:
        """Create a push protection bypass

        Creates a bypass for a previously push protected secret.  The authenticated user must be the original author of the committed secret.  OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param secret_scanning_create_push_protection_bypass_request: (required)
        :type secret_scanning_create_push_protection_bypass_request: SecretScanningCreatePushProtectionBypassRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_create_push_protection_bypass_serialize(
            owner=owner,
            repo=repo,
            secret_scanning_create_push_protection_bypass_request=secret_scanning_create_push_protection_bypass_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningPushProtectionBypass",
            '403': None,
            '404': None,
            '422': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_create_push_protection_bypass_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        secret_scanning_create_push_protection_bypass_request: SecretScanningCreatePushProtectionBypassRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a push protection bypass

        Creates a bypass for a previously push protected secret.  The authenticated user must be the original author of the committed secret.  OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param secret_scanning_create_push_protection_bypass_request: (required)
        :type secret_scanning_create_push_protection_bypass_request: SecretScanningCreatePushProtectionBypassRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_create_push_protection_bypass_serialize(
            owner=owner,
            repo=repo,
            secret_scanning_create_push_protection_bypass_request=secret_scanning_create_push_protection_bypass_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningPushProtectionBypass",
            '403': None,
            '404': None,
            '422': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_create_push_protection_bypass_serialize(
        self,
        owner,
        repo,
        secret_scanning_create_push_protection_bypass_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if secret_scanning_create_push_protection_bypass_request is not None:
            _body_params = secret_scanning_create_push_protection_bypass_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_get_alert(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SecretScanningAlert:
        """Get a secret scanning alert

        Gets a single secret scanning alert detected in an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_get_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningAlert",
            '304': None,
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_get_alert_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SecretScanningAlert]:
        """Get a secret scanning alert

        Gets a single secret scanning alert detected in an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_get_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningAlert",
            '304': None,
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_get_alert_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a secret scanning alert

        Gets a single secret scanning alert detected in an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_get_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningAlert",
            '304': None,
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_get_alert_serialize(
        self,
        owner,
        repo,
        alert_number,
        hide_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        if alert_number is not None:
            _path_params['alert_number'] = alert_number
        # process the query parameters
        if hide_secret is not None:
            
            _query_params.append(('hide_secret', hide_secret))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_get_scan_history(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SecretScanningScanHistory:
        """Get secret scanning scan history for a repository

        Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_get_scan_history_serialize(
            owner=owner,
            repo=repo,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
            '200': "SecretScanningScanHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_get_scan_history_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SecretScanningScanHistory]:
        """Get secret scanning scan history for a repository

        Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_get_scan_history_serialize(
            owner=owner,
            repo=repo,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
            '200': "SecretScanningScanHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_get_scan_history_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get secret scanning scan history for a repository

        Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_get_scan_history_serialize(
            owner=owner,
            repo=repo,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
            '200': "SecretScanningScanHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_get_scan_history_serialize(
        self,
        owner,
        repo,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/repos/{owner}/{repo}/secret-scanning/scan-history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_list_alerts_for_enterprise(
        self,
        enterprise: Annotated[StrictStr, Field(description="The slug version of the enterprise name.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[OrganizationSecretScanningAlert]:
        """List secret scanning alerts for an enterprise

        Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.  Alerts are only returned for organizations in the enterprise for which the authenticated user is an organization owner or a [security manager](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).  The authenticated user must be a member of the enterprise in order to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` scope or `security_events` scope to use this endpoint.

        :param enterprise: The slug version of the enterprise name. (required)
        :type enterprise: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_enterprise_serialize(
            enterprise=enterprise,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OrganizationSecretScanningAlert]",
            '404': "BasicError",
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_list_alerts_for_enterprise_with_http_info(
        self,
        enterprise: Annotated[StrictStr, Field(description="The slug version of the enterprise name.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[OrganizationSecretScanningAlert]]:
        """List secret scanning alerts for an enterprise

        Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.  Alerts are only returned for organizations in the enterprise for which the authenticated user is an organization owner or a [security manager](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).  The authenticated user must be a member of the enterprise in order to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` scope or `security_events` scope to use this endpoint.

        :param enterprise: The slug version of the enterprise name. (required)
        :type enterprise: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_enterprise_serialize(
            enterprise=enterprise,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OrganizationSecretScanningAlert]",
            '404': "BasicError",
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_list_alerts_for_enterprise_without_preload_content(
        self,
        enterprise: Annotated[StrictStr, Field(description="The slug version of the enterprise name.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List secret scanning alerts for an enterprise

        Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.  Alerts are only returned for organizations in the enterprise for which the authenticated user is an organization owner or a [security manager](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).  The authenticated user must be a member of the enterprise in order to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` scope or `security_events` scope to use this endpoint.

        :param enterprise: The slug version of the enterprise name. (required)
        :type enterprise: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_enterprise_serialize(
            enterprise=enterprise,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OrganizationSecretScanningAlert]",
            '404': "BasicError",
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_list_alerts_for_enterprise_serialize(
        self,
        enterprise,
        state,
        secret_type,
        resolution,
        sort,
        direction,
        per_page,
        before,
        after,
        validity,
        is_publicly_leaked,
        is_multi_repo,
        hide_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if enterprise is not None:
            _path_params['enterprise'] = enterprise
        # process the query parameters
        if state is not None:
            
            _query_params.append(('state', state))
            
        if secret_type is not None:
            
            _query_params.append(('secret_type', secret_type))
            
        if resolution is not None:
            
            _query_params.append(('resolution', resolution))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if direction is not None:
            
            _query_params.append(('direction', direction))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if before is not None:
            
            _query_params.append(('before', before))
            
        if after is not None:
            
            _query_params.append(('after', after))
            
        if validity is not None:
            
            _query_params.append(('validity', validity))
            
        if is_publicly_leaked is not None:
            
            _query_params.append(('is_publicly_leaked', is_publicly_leaked))
            
        if is_multi_repo is not None:
            
            _query_params.append(('is_multi_repo', is_multi_repo))
            
        if hide_secret is not None:
            
            _query_params.append(('hide_secret', hide_secret))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/enterprises/{enterprise}/secret-scanning/alerts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_list_alerts_for_org(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[OrganizationSecretScanningAlert]:
        """List secret scanning alerts for an organization

        Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.  The authenticated user must be an administrator or security manager for the organization to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_org_serialize(
            org=org,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            page=page,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OrganizationSecretScanningAlert]",
            '404': "BasicError",
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_list_alerts_for_org_with_http_info(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[OrganizationSecretScanningAlert]]:
        """List secret scanning alerts for an organization

        Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.  The authenticated user must be an administrator or security manager for the organization to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_org_serialize(
            org=org,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            page=page,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OrganizationSecretScanningAlert]",
            '404': "BasicError",
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_list_alerts_for_org_without_preload_content(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List secret scanning alerts for an organization

        Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.  The authenticated user must be an administrator or security manager for the organization to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_org_serialize(
            org=org,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            page=page,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OrganizationSecretScanningAlert]",
            '404': "BasicError",
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_list_alerts_for_org_serialize(
        self,
        org,
        state,
        secret_type,
        resolution,
        sort,
        direction,
        page,
        per_page,
        before,
        after,
        validity,
        is_publicly_leaked,
        is_multi_repo,
        hide_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if state is not None:
            
            _query_params.append(('state', state))
            
        if secret_type is not None:
            
            _query_params.append(('secret_type', secret_type))
            
        if resolution is not None:
            
            _query_params.append(('resolution', resolution))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if direction is not None:
            
            _query_params.append(('direction', direction))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if before is not None:
            
            _query_params.append(('before', before))
            
        if after is not None:
            
            _query_params.append(('after', after))
            
        if validity is not None:
            
            _query_params.append(('validity', validity))
            
        if is_publicly_leaked is not None:
            
            _query_params.append(('is_publicly_leaked', is_publicly_leaked))
            
        if is_multi_repo is not None:
            
            _query_params.append(('is_multi_repo', is_multi_repo))
            
        if hide_secret is not None:
            
            _query_params.append(('hide_secret', hide_secret))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/orgs/{org}/secret-scanning/alerts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_list_alerts_for_repo(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[SecretScanningAlert]:
        """List secret scanning alerts for a repository

        Lists secret scanning alerts for an eligible repository, from newest to oldest.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_repo_serialize(
            owner=owner,
            repo=repo,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            page=page,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SecretScanningAlert]",
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_list_alerts_for_repo_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[SecretScanningAlert]]:
        """List secret scanning alerts for a repository

        Lists secret scanning alerts for an eligible repository, from newest to oldest.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_repo_serialize(
            owner=owner,
            repo=repo,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            page=page,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SecretScanningAlert]",
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_list_alerts_for_repo_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        state: Annotated[Optional[StrictStr], Field(description="Set to `open` or `resolved` to only list secret scanning alerts in a specific state.")] = None,
        secret_type: Annotated[Optional[StrictStr], Field(description="A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.")] = None,
        resolution: Annotated[Optional[StrictStr], Field(description="A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.")] = None,
        validity: Annotated[Optional[StrictStr], Field(description="A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.")] = None,
        is_publicly_leaked: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.")] = None,
        is_multi_repo: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to filter alerts by the multi-repo tag being present.")] = None,
        hide_secret: Annotated[Optional[StrictBool], Field(description="A boolean value representing whether or not to hide literal secrets in the results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List secret scanning alerts for a repository

        Lists secret scanning alerts for an eligible repository, from newest to oldest.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        :type state: str
        :param secret_type: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)\" for a complete list of secret types.
        :type secret_type: str
        :param resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        :type resolution: str
        :param sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        :type sort: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty \"before\" query string.
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty \"after\" query string.
        :type after: str
        :param validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        :type validity: str
        :param is_publicly_leaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        :type is_publicly_leaked: bool
        :param is_multi_repo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        :type is_multi_repo: bool
        :param hide_secret: A boolean value representing whether or not to hide literal secrets in the results.
        :type hide_secret: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_alerts_for_repo_serialize(
            owner=owner,
            repo=repo,
            state=state,
            secret_type=secret_type,
            resolution=resolution,
            sort=sort,
            direction=direction,
            page=page,
            per_page=per_page,
            before=before,
            after=after,
            validity=validity,
            is_publicly_leaked=is_publicly_leaked,
            is_multi_repo=is_multi_repo,
            hide_secret=hide_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SecretScanningAlert]",
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_list_alerts_for_repo_serialize(
        self,
        owner,
        repo,
        state,
        secret_type,
        resolution,
        sort,
        direction,
        page,
        per_page,
        before,
        after,
        validity,
        is_publicly_leaked,
        is_multi_repo,
        hide_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        # process the query parameters
        if state is not None:
            
            _query_params.append(('state', state))
            
        if secret_type is not None:
            
            _query_params.append(('secret_type', secret_type))
            
        if resolution is not None:
            
            _query_params.append(('resolution', resolution))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if direction is not None:
            
            _query_params.append(('direction', direction))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if before is not None:
            
            _query_params.append(('before', before))
            
        if after is not None:
            
            _query_params.append(('after', after))
            
        if validity is not None:
            
            _query_params.append(('validity', validity))
            
        if is_publicly_leaked is not None:
            
            _query_params.append(('is_publicly_leaked', is_publicly_leaked))
            
        if is_multi_repo is not None:
            
            _query_params.append(('is_multi_repo', is_multi_repo))
            
        if hide_secret is not None:
            
            _query_params.append(('hide_secret', hide_secret))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/repos/{owner}/{repo}/secret-scanning/alerts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_list_locations_for_alert(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[SecretScanningLocation]:
        """List locations for a secret scanning alert

        Lists all locations for a given secret scanning alert for an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_locations_for_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            page=page,
            per_page=per_page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SecretScanningLocation]",
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_list_locations_for_alert_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[SecretScanningLocation]]:
        """List locations for a secret scanning alert

        Lists all locations for a given secret scanning alert for an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_locations_for_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            page=page,
            per_page=per_page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SecretScanningLocation]",
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_list_locations_for_alert_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        page: Annotated[Optional[StrictInt], Field(description="The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List locations for a secret scanning alert

        Lists all locations for a given secret scanning alert for an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param page: The page number of the results to fetch. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type page: int
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_locations_for_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            page=page,
            per_page=per_page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SecretScanningLocation]",
            '404': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_list_locations_for_alert_serialize(
        self,
        owner,
        repo,
        alert_number,
        page,
        per_page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        if alert_number is not None:
            _path_params['alert_number'] = alert_number
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_list_org_pattern_configs(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SecretScanningPatternConfiguration:
        """List organization pattern configurations

        Lists the secret scanning pattern configurations for an organization.  Personal access tokens (classic) need the `read:org` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_org_pattern_configs_serialize(
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningPatternConfiguration",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_list_org_pattern_configs_with_http_info(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SecretScanningPatternConfiguration]:
        """List organization pattern configurations

        Lists the secret scanning pattern configurations for an organization.  Personal access tokens (classic) need the `read:org` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_org_pattern_configs_serialize(
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningPatternConfiguration",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_list_org_pattern_configs_without_preload_content(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List organization pattern configurations

        Lists the secret scanning pattern configurations for an organization.  Personal access tokens (classic) need the `read:org` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_list_org_pattern_configs_serialize(
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningPatternConfiguration",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_list_org_pattern_configs_serialize(
        self,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/orgs/{org}/secret-scanning/pattern-configurations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_update_alert(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        secret_scanning_update_alert_request: SecretScanningUpdateAlertRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SecretScanningAlert:
        """Update a secret scanning alert

        Updates the status of a secret scanning alert in an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param secret_scanning_update_alert_request: (required)
        :type secret_scanning_update_alert_request: SecretScanningUpdateAlertRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_update_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            secret_scanning_update_alert_request=secret_scanning_update_alert_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningAlert",
            '400': None,
            '404': None,
            '422': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_update_alert_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        secret_scanning_update_alert_request: SecretScanningUpdateAlertRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SecretScanningAlert]:
        """Update a secret scanning alert

        Updates the status of a secret scanning alert in an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param secret_scanning_update_alert_request: (required)
        :type secret_scanning_update_alert_request: SecretScanningUpdateAlertRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_update_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            secret_scanning_update_alert_request=secret_scanning_update_alert_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningAlert",
            '400': None,
            '404': None,
            '422': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_update_alert_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        alert_number: Annotated[StrictInt, Field(description="The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.")],
        secret_scanning_update_alert_request: SecretScanningUpdateAlertRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a secret scanning alert

        Updates the status of a secret scanning alert in an eligible repository.  The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param alert_number: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. (required)
        :type alert_number: int
        :param secret_scanning_update_alert_request: (required)
        :type secret_scanning_update_alert_request: SecretScanningUpdateAlertRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_update_alert_serialize(
            owner=owner,
            repo=repo,
            alert_number=alert_number,
            secret_scanning_update_alert_request=secret_scanning_update_alert_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningAlert",
            '400': None,
            '404': None,
            '422': None,
            '503': "SecretScanningListAlertsForEnterprise503Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_update_alert_serialize(
        self,
        owner,
        repo,
        alert_number,
        secret_scanning_update_alert_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        if alert_number is not None:
            _path_params['alert_number'] = alert_number
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if secret_scanning_update_alert_request is not None:
            _body_params = secret_scanning_update_alert_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def secret_scanning_update_org_pattern_configs(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        secret_scanning_update_org_pattern_configs_request: SecretScanningUpdateOrgPatternConfigsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SecretScanningUpdateOrgPatternConfigs200Response:
        """Update organization pattern configurations

        Updates the secret scanning pattern configurations for an organization.  Personal access tokens (classic) need the `write:org` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param secret_scanning_update_org_pattern_configs_request: (required)
        :type secret_scanning_update_org_pattern_configs_request: SecretScanningUpdateOrgPatternConfigsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_update_org_pattern_configs_serialize(
            org=org,
            secret_scanning_update_org_pattern_configs_request=secret_scanning_update_org_pattern_configs_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningUpdateOrgPatternConfigs200Response",
            '400': "BasicError",
            '403': "BasicError",
            '404': "BasicError",
            '409': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def secret_scanning_update_org_pattern_configs_with_http_info(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        secret_scanning_update_org_pattern_configs_request: SecretScanningUpdateOrgPatternConfigsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SecretScanningUpdateOrgPatternConfigs200Response]:
        """Update organization pattern configurations

        Updates the secret scanning pattern configurations for an organization.  Personal access tokens (classic) need the `write:org` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param secret_scanning_update_org_pattern_configs_request: (required)
        :type secret_scanning_update_org_pattern_configs_request: SecretScanningUpdateOrgPatternConfigsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_update_org_pattern_configs_serialize(
            org=org,
            secret_scanning_update_org_pattern_configs_request=secret_scanning_update_org_pattern_configs_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningUpdateOrgPatternConfigs200Response",
            '400': "BasicError",
            '403': "BasicError",
            '404': "BasicError",
            '409': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def secret_scanning_update_org_pattern_configs_without_preload_content(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        secret_scanning_update_org_pattern_configs_request: SecretScanningUpdateOrgPatternConfigsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update organization pattern configurations

        Updates the secret scanning pattern configurations for an organization.  Personal access tokens (classic) need the `write:org` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param secret_scanning_update_org_pattern_configs_request: (required)
        :type secret_scanning_update_org_pattern_configs_request: SecretScanningUpdateOrgPatternConfigsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._secret_scanning_update_org_pattern_configs_serialize(
            org=org,
            secret_scanning_update_org_pattern_configs_request=secret_scanning_update_org_pattern_configs_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SecretScanningUpdateOrgPatternConfigs200Response",
            '400': "BasicError",
            '403': "BasicError",
            '404': "BasicError",
            '409': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _secret_scanning_update_org_pattern_configs_serialize(
        self,
        org,
        secret_scanning_update_org_pattern_configs_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if secret_scanning_update_org_pattern_configs_request is not None:
            _body_params = secret_scanning_update_org_pattern_configs_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/scim+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/orgs/{org}/secret-scanning/pattern-configurations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


