# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.full_repository import FullRepository
from devopso.clients.github.models.global_advisory import GlobalAdvisory
from devopso.clients.github.models.private_vulnerability_report_create import PrivateVulnerabilityReportCreate
from devopso.clients.github.models.repository_advisory import RepositoryAdvisory
from devopso.clients.github.models.repository_advisory_create import RepositoryAdvisoryCreate
from devopso.clients.github.models.repository_advisory_update import RepositoryAdvisoryUpdate
from devopso.clients.github.models.security_advisory_ecosystems import SecurityAdvisoryEcosystems

from devopso.clients.github.api_client import ApiClient, RequestSerialized
from devopso.clients.github.api_response import ApiResponse
from devopso.clients.github.rest import RESTResponseType


class SecurityAdvisoriesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def security_advisories_create_fork(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FullRepository:
        """Create a temporary private fork

        Create a temporary private fork to collaborate on fixing a security vulnerability in your repository.  > [!NOTE] > Forking a repository happens asynchronously. You may have to wait up to 5 minutes before you can access the fork.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_fork_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "FullRepository",
            '400': "BasicError",
            '422': "ValidationError",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_create_fork_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FullRepository]:
        """Create a temporary private fork

        Create a temporary private fork to collaborate on fixing a security vulnerability in your repository.  > [!NOTE] > Forking a repository happens asynchronously. You may have to wait up to 5 minutes before you can access the fork.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_fork_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "FullRepository",
            '400': "BasicError",
            '422': "ValidationError",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_create_fork_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a temporary private fork

        Create a temporary private fork to collaborate on fixing a security vulnerability in your repository.  > [!NOTE] > Forking a repository happens asynchronously. You may have to wait up to 5 minutes before you can access the fork.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_fork_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "FullRepository",
            '400': "BasicError",
            '422': "ValidationError",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_create_fork_serialize(
        self,
        owner,
        repo,
        ghsa_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        if ghsa_id is not None:
            _path_params['ghsa_id'] = ghsa_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/scim+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_create_private_vulnerability_report(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        private_vulnerability_report_create: PrivateVulnerabilityReportCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RepositoryAdvisory:
        """Privately report a security vulnerability

        Report a security vulnerability to the maintainers of the repository. See \"[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)\" for more information about private vulnerability reporting.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param private_vulnerability_report_create: (required)
        :type private_vulnerability_report_create: PrivateVulnerabilityReportCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_private_vulnerability_report_serialize(
            owner=owner,
            repo=repo,
            private_vulnerability_report_create=private_vulnerability_report_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_create_private_vulnerability_report_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        private_vulnerability_report_create: PrivateVulnerabilityReportCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RepositoryAdvisory]:
        """Privately report a security vulnerability

        Report a security vulnerability to the maintainers of the repository. See \"[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)\" for more information about private vulnerability reporting.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param private_vulnerability_report_create: (required)
        :type private_vulnerability_report_create: PrivateVulnerabilityReportCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_private_vulnerability_report_serialize(
            owner=owner,
            repo=repo,
            private_vulnerability_report_create=private_vulnerability_report_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_create_private_vulnerability_report_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        private_vulnerability_report_create: PrivateVulnerabilityReportCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Privately report a security vulnerability

        Report a security vulnerability to the maintainers of the repository. See \"[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)\" for more information about private vulnerability reporting.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param private_vulnerability_report_create: (required)
        :type private_vulnerability_report_create: PrivateVulnerabilityReportCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_private_vulnerability_report_serialize(
            owner=owner,
            repo=repo,
            private_vulnerability_report_create=private_vulnerability_report_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_create_private_vulnerability_report_serialize(
        self,
        owner,
        repo,
        private_vulnerability_report_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if private_vulnerability_report_create is not None:
            _body_params = private_vulnerability_report_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/repos/{owner}/{repo}/security-advisories/reports',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_create_repository_advisory(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        repository_advisory_create: RepositoryAdvisoryCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RepositoryAdvisory:
        """Create a repository security advisory

        Creates a new repository security advisory.  In order to create a draft repository security advisory, the authenticated user must be a security manager or administrator of that repository.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param repository_advisory_create: (required)
        :type repository_advisory_create: RepositoryAdvisoryCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            repository_advisory_create=repository_advisory_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_create_repository_advisory_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        repository_advisory_create: RepositoryAdvisoryCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RepositoryAdvisory]:
        """Create a repository security advisory

        Creates a new repository security advisory.  In order to create a draft repository security advisory, the authenticated user must be a security manager or administrator of that repository.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param repository_advisory_create: (required)
        :type repository_advisory_create: RepositoryAdvisoryCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            repository_advisory_create=repository_advisory_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_create_repository_advisory_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        repository_advisory_create: RepositoryAdvisoryCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a repository security advisory

        Creates a new repository security advisory.  In order to create a draft repository security advisory, the authenticated user must be a security manager or administrator of that repository.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param repository_advisory_create: (required)
        :type repository_advisory_create: RepositoryAdvisoryCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            repository_advisory_create=repository_advisory_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_create_repository_advisory_serialize(
        self,
        owner,
        repo,
        repository_advisory_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if repository_advisory_create is not None:
            _body_params = repository_advisory_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/repos/{owner}/{repo}/security-advisories',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_create_repository_advisory_cve_request(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Request a CVE for a repository security advisory

        If you want a CVE identification number for the security vulnerability in your project, and don't already have one, you can request a CVE identification number from GitHub. For more information see \"[Requesting a CVE identification number](https://docs.github.com/code-security/security-advisories/repository-security-advisories/publishing-a-repository-security-advisory#requesting-a-cve-identification-number-optional).\"  You may request a CVE for public repositories, but cannot do so for private repositories.  In order to request a CVE for a repository security advisory, the authenticated user must be a security manager or administrator of that repository.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_repository_advisory_cve_request_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "object",
            '400': "BasicError",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_create_repository_advisory_cve_request_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Request a CVE for a repository security advisory

        If you want a CVE identification number for the security vulnerability in your project, and don't already have one, you can request a CVE identification number from GitHub. For more information see \"[Requesting a CVE identification number](https://docs.github.com/code-security/security-advisories/repository-security-advisories/publishing-a-repository-security-advisory#requesting-a-cve-identification-number-optional).\"  You may request a CVE for public repositories, but cannot do so for private repositories.  In order to request a CVE for a repository security advisory, the authenticated user must be a security manager or administrator of that repository.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_repository_advisory_cve_request_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "object",
            '400': "BasicError",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_create_repository_advisory_cve_request_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Request a CVE for a repository security advisory

        If you want a CVE identification number for the security vulnerability in your project, and don't already have one, you can request a CVE identification number from GitHub. For more information see \"[Requesting a CVE identification number](https://docs.github.com/code-security/security-advisories/repository-security-advisories/publishing-a-repository-security-advisory#requesting-a-cve-identification-number-optional).\"  You may request a CVE for public repositories, but cannot do so for private repositories.  In order to request a CVE for a repository security advisory, the authenticated user must be a security manager or administrator of that repository.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_create_repository_advisory_cve_request_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "object",
            '400': "BasicError",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_create_repository_advisory_cve_request_serialize(
        self,
        owner,
        repo,
        ghsa_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        if ghsa_id is not None:
            _path_params['ghsa_id'] = ghsa_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/scim+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_get_global_advisory(
        self,
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GlobalAdvisory:
        """Get a global security advisory

        Gets a global security advisory using its GitHub Security Advisory (GHSA) identifier.

        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_get_global_advisory_serialize(
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GlobalAdvisory",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_get_global_advisory_with_http_info(
        self,
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GlobalAdvisory]:
        """Get a global security advisory

        Gets a global security advisory using its GitHub Security Advisory (GHSA) identifier.

        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_get_global_advisory_serialize(
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GlobalAdvisory",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_get_global_advisory_without_preload_content(
        self,
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a global security advisory

        Gets a global security advisory using its GitHub Security Advisory (GHSA) identifier.

        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_get_global_advisory_serialize(
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GlobalAdvisory",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_get_global_advisory_serialize(
        self,
        ghsa_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ghsa_id is not None:
            _path_params['ghsa_id'] = ghsa_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/advisories/{ghsa_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_get_repository_advisory(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RepositoryAdvisory:
        """Get a repository security advisory

        Get a repository security advisory using its GitHub Security Advisory (GHSA) identifier.  Anyone can access any published security advisory on a public repository.  The authenticated user can access an unpublished security advisory from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on the security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_get_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_get_repository_advisory_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RepositoryAdvisory]:
        """Get a repository security advisory

        Get a repository security advisory using its GitHub Security Advisory (GHSA) identifier.  Anyone can access any published security advisory on a public repository.  The authenticated user can access an unpublished security advisory from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on the security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_get_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_get_repository_advisory_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a repository security advisory

        Get a repository security advisory using its GitHub Security Advisory (GHSA) identifier.  Anyone can access any published security advisory on a public repository.  The authenticated user can access an unpublished security advisory from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on the security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_get_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_get_repository_advisory_serialize(
        self,
        owner,
        repo,
        ghsa_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        if ghsa_id is not None:
            _path_params['ghsa_id'] = ghsa_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/repos/{owner}/{repo}/security-advisories/{ghsa_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_list_global_advisories(
        self,
        ghsa_id: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with this GHSA (GitHub Security Advisory) identifier will be returned.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="If specified, only advisories of this type will be returned. By default, a request with no other parameters defined will only return reviewed advisories that are not malware.")] = None,
        cve_id: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with this CVE (Common Vulnerabilities and Exposures) identifier will be returned.")] = None,
        ecosystem: Annotated[Optional[SecurityAdvisoryEcosystems], Field(description="If specified, only advisories for these ecosystems will be returned.")] = None,
        severity: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with these severities will be returned.")] = None,
        cwes: Annotated[Optional[Any], Field(description="If specified, only advisories with these Common Weakness Enumerations (CWEs) will be returned.  Example: `cwes=79,284,22` or `cwes[]=79&cwes[]=284&cwes[]=22`")] = None,
        is_withdrawn: Annotated[Optional[StrictBool], Field(description="Whether to only return advisories that have been withdrawn.")] = None,
        affects: Annotated[Optional[Any], Field(description="If specified, only return advisories that affect any of `package` or `package@version`. A maximum of 1000 packages can be specified. If the query parameter causes the URL to exceed the maximum URL length supported by your client, you must specify fewer packages.  Example: `affects=package1,package2@1.0.0,package3@2.0.0` or `affects[]=package1&affects[]=package2@1.0.0`")] = None,
        published: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that were published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        updated: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that were updated on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        modified: Annotated[Optional[StrictStr], Field(description="If specified, only show advisories that were updated or published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        epss_percentage: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that have an EPSS percentage score that matches the provided value. The EPSS percentage represents the likelihood of a CVE being exploited.")] = None,
        epss_percentile: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that have an EPSS percentile score that matches the provided value. The EPSS percentile represents the relative rank of the CVE's likelihood of being exploited compared to other CVEs.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[GlobalAdvisory]:
        """List global security advisories

        Lists all global security advisories that match the specified parameters. If no other parameters are defined, the request will return only GitHub-reviewed advisories that are not malware.  By default, all responses will exclude advisories for malware, because malware are not standard vulnerabilities. To list advisories for malware, you must include the `type` parameter in your request, with the value `malware`. For more information about the different types of security advisories, see \"[About the GitHub Advisory database](https://docs.github.com/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database#about-types-of-security-advisories).\"

        :param ghsa_id: If specified, only advisories with this GHSA (GitHub Security Advisory) identifier will be returned.
        :type ghsa_id: str
        :param type: If specified, only advisories of this type will be returned. By default, a request with no other parameters defined will only return reviewed advisories that are not malware.
        :type type: str
        :param cve_id: If specified, only advisories with this CVE (Common Vulnerabilities and Exposures) identifier will be returned.
        :type cve_id: str
        :param ecosystem: If specified, only advisories for these ecosystems will be returned.
        :type ecosystem: SecurityAdvisoryEcosystems
        :param severity: If specified, only advisories with these severities will be returned.
        :type severity: str
        :param cwes: If specified, only advisories with these Common Weakness Enumerations (CWEs) will be returned.  Example: `cwes=79,284,22` or `cwes[]=79&cwes[]=284&cwes[]=22`
        :type cwes: SecurityAdvisoriesListGlobalAdvisoriesCwesParameter
        :param is_withdrawn: Whether to only return advisories that have been withdrawn.
        :type is_withdrawn: bool
        :param affects: If specified, only return advisories that affect any of `package` or `package@version`. A maximum of 1000 packages can be specified. If the query parameter causes the URL to exceed the maximum URL length supported by your client, you must specify fewer packages.  Example: `affects=package1,package2@1.0.0,package3@2.0.0` or `affects[]=package1&affects[]=package2@1.0.0`
        :type affects: SecurityAdvisoriesListGlobalAdvisoriesAffectsParameter
        :param published: If specified, only return advisories that were published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type published: str
        :param updated: If specified, only return advisories that were updated on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type updated: str
        :param modified: If specified, only show advisories that were updated or published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type modified: str
        :param epss_percentage: If specified, only return advisories that have an EPSS percentage score that matches the provided value. The EPSS percentage represents the likelihood of a CVE being exploited.
        :type epss_percentage: str
        :param epss_percentile: If specified, only return advisories that have an EPSS percentile score that matches the provided value. The EPSS percentile represents the relative rank of the CVE's likelihood of being exploited compared to other CVEs.
        :type epss_percentile: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param sort: The property to sort the results by.
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_global_advisories_serialize(
            ghsa_id=ghsa_id,
            type=type,
            cve_id=cve_id,
            ecosystem=ecosystem,
            severity=severity,
            cwes=cwes,
            is_withdrawn=is_withdrawn,
            affects=affects,
            published=published,
            updated=updated,
            modified=modified,
            epss_percentage=epss_percentage,
            epss_percentile=epss_percentile,
            before=before,
            after=after,
            direction=direction,
            per_page=per_page,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GlobalAdvisory]",
            '429': "BasicError",
            '422': "ValidationErrorSimple",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_list_global_advisories_with_http_info(
        self,
        ghsa_id: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with this GHSA (GitHub Security Advisory) identifier will be returned.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="If specified, only advisories of this type will be returned. By default, a request with no other parameters defined will only return reviewed advisories that are not malware.")] = None,
        cve_id: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with this CVE (Common Vulnerabilities and Exposures) identifier will be returned.")] = None,
        ecosystem: Annotated[Optional[SecurityAdvisoryEcosystems], Field(description="If specified, only advisories for these ecosystems will be returned.")] = None,
        severity: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with these severities will be returned.")] = None,
        cwes: Annotated[Optional[Any], Field(description="If specified, only advisories with these Common Weakness Enumerations (CWEs) will be returned.  Example: `cwes=79,284,22` or `cwes[]=79&cwes[]=284&cwes[]=22`")] = None,
        is_withdrawn: Annotated[Optional[StrictBool], Field(description="Whether to only return advisories that have been withdrawn.")] = None,
        affects: Annotated[Optional[Any], Field(description="If specified, only return advisories that affect any of `package` or `package@version`. A maximum of 1000 packages can be specified. If the query parameter causes the URL to exceed the maximum URL length supported by your client, you must specify fewer packages.  Example: `affects=package1,package2@1.0.0,package3@2.0.0` or `affects[]=package1&affects[]=package2@1.0.0`")] = None,
        published: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that were published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        updated: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that were updated on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        modified: Annotated[Optional[StrictStr], Field(description="If specified, only show advisories that were updated or published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        epss_percentage: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that have an EPSS percentage score that matches the provided value. The EPSS percentage represents the likelihood of a CVE being exploited.")] = None,
        epss_percentile: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that have an EPSS percentile score that matches the provided value. The EPSS percentile represents the relative rank of the CVE's likelihood of being exploited compared to other CVEs.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[GlobalAdvisory]]:
        """List global security advisories

        Lists all global security advisories that match the specified parameters. If no other parameters are defined, the request will return only GitHub-reviewed advisories that are not malware.  By default, all responses will exclude advisories for malware, because malware are not standard vulnerabilities. To list advisories for malware, you must include the `type` parameter in your request, with the value `malware`. For more information about the different types of security advisories, see \"[About the GitHub Advisory database](https://docs.github.com/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database#about-types-of-security-advisories).\"

        :param ghsa_id: If specified, only advisories with this GHSA (GitHub Security Advisory) identifier will be returned.
        :type ghsa_id: str
        :param type: If specified, only advisories of this type will be returned. By default, a request with no other parameters defined will only return reviewed advisories that are not malware.
        :type type: str
        :param cve_id: If specified, only advisories with this CVE (Common Vulnerabilities and Exposures) identifier will be returned.
        :type cve_id: str
        :param ecosystem: If specified, only advisories for these ecosystems will be returned.
        :type ecosystem: SecurityAdvisoryEcosystems
        :param severity: If specified, only advisories with these severities will be returned.
        :type severity: str
        :param cwes: If specified, only advisories with these Common Weakness Enumerations (CWEs) will be returned.  Example: `cwes=79,284,22` or `cwes[]=79&cwes[]=284&cwes[]=22`
        :type cwes: SecurityAdvisoriesListGlobalAdvisoriesCwesParameter
        :param is_withdrawn: Whether to only return advisories that have been withdrawn.
        :type is_withdrawn: bool
        :param affects: If specified, only return advisories that affect any of `package` or `package@version`. A maximum of 1000 packages can be specified. If the query parameter causes the URL to exceed the maximum URL length supported by your client, you must specify fewer packages.  Example: `affects=package1,package2@1.0.0,package3@2.0.0` or `affects[]=package1&affects[]=package2@1.0.0`
        :type affects: SecurityAdvisoriesListGlobalAdvisoriesAffectsParameter
        :param published: If specified, only return advisories that were published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type published: str
        :param updated: If specified, only return advisories that were updated on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type updated: str
        :param modified: If specified, only show advisories that were updated or published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type modified: str
        :param epss_percentage: If specified, only return advisories that have an EPSS percentage score that matches the provided value. The EPSS percentage represents the likelihood of a CVE being exploited.
        :type epss_percentage: str
        :param epss_percentile: If specified, only return advisories that have an EPSS percentile score that matches the provided value. The EPSS percentile represents the relative rank of the CVE's likelihood of being exploited compared to other CVEs.
        :type epss_percentile: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param sort: The property to sort the results by.
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_global_advisories_serialize(
            ghsa_id=ghsa_id,
            type=type,
            cve_id=cve_id,
            ecosystem=ecosystem,
            severity=severity,
            cwes=cwes,
            is_withdrawn=is_withdrawn,
            affects=affects,
            published=published,
            updated=updated,
            modified=modified,
            epss_percentage=epss_percentage,
            epss_percentile=epss_percentile,
            before=before,
            after=after,
            direction=direction,
            per_page=per_page,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GlobalAdvisory]",
            '429': "BasicError",
            '422': "ValidationErrorSimple",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_list_global_advisories_without_preload_content(
        self,
        ghsa_id: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with this GHSA (GitHub Security Advisory) identifier will be returned.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="If specified, only advisories of this type will be returned. By default, a request with no other parameters defined will only return reviewed advisories that are not malware.")] = None,
        cve_id: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with this CVE (Common Vulnerabilities and Exposures) identifier will be returned.")] = None,
        ecosystem: Annotated[Optional[SecurityAdvisoryEcosystems], Field(description="If specified, only advisories for these ecosystems will be returned.")] = None,
        severity: Annotated[Optional[StrictStr], Field(description="If specified, only advisories with these severities will be returned.")] = None,
        cwes: Annotated[Optional[Any], Field(description="If specified, only advisories with these Common Weakness Enumerations (CWEs) will be returned.  Example: `cwes=79,284,22` or `cwes[]=79&cwes[]=284&cwes[]=22`")] = None,
        is_withdrawn: Annotated[Optional[StrictBool], Field(description="Whether to only return advisories that have been withdrawn.")] = None,
        affects: Annotated[Optional[Any], Field(description="If specified, only return advisories that affect any of `package` or `package@version`. A maximum of 1000 packages can be specified. If the query parameter causes the URL to exceed the maximum URL length supported by your client, you must specify fewer packages.  Example: `affects=package1,package2@1.0.0,package3@2.0.0` or `affects[]=package1&affects[]=package2@1.0.0`")] = None,
        published: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that were published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        updated: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that were updated on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        modified: Annotated[Optional[StrictStr], Field(description="If specified, only show advisories that were updated or published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"")] = None,
        epss_percentage: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that have an EPSS percentage score that matches the provided value. The EPSS percentage represents the likelihood of a CVE being exploited.")] = None,
        epss_percentile: Annotated[Optional[StrictStr], Field(description="If specified, only return advisories that have an EPSS percentile score that matches the provided value. The EPSS percentile represents the relative rank of the CVE's likelihood of being exploited compared to other CVEs.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List global security advisories

        Lists all global security advisories that match the specified parameters. If no other parameters are defined, the request will return only GitHub-reviewed advisories that are not malware.  By default, all responses will exclude advisories for malware, because malware are not standard vulnerabilities. To list advisories for malware, you must include the `type` parameter in your request, with the value `malware`. For more information about the different types of security advisories, see \"[About the GitHub Advisory database](https://docs.github.com/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database#about-types-of-security-advisories).\"

        :param ghsa_id: If specified, only advisories with this GHSA (GitHub Security Advisory) identifier will be returned.
        :type ghsa_id: str
        :param type: If specified, only advisories of this type will be returned. By default, a request with no other parameters defined will only return reviewed advisories that are not malware.
        :type type: str
        :param cve_id: If specified, only advisories with this CVE (Common Vulnerabilities and Exposures) identifier will be returned.
        :type cve_id: str
        :param ecosystem: If specified, only advisories for these ecosystems will be returned.
        :type ecosystem: SecurityAdvisoryEcosystems
        :param severity: If specified, only advisories with these severities will be returned.
        :type severity: str
        :param cwes: If specified, only advisories with these Common Weakness Enumerations (CWEs) will be returned.  Example: `cwes=79,284,22` or `cwes[]=79&cwes[]=284&cwes[]=22`
        :type cwes: SecurityAdvisoriesListGlobalAdvisoriesCwesParameter
        :param is_withdrawn: Whether to only return advisories that have been withdrawn.
        :type is_withdrawn: bool
        :param affects: If specified, only return advisories that affect any of `package` or `package@version`. A maximum of 1000 packages can be specified. If the query parameter causes the URL to exceed the maximum URL length supported by your client, you must specify fewer packages.  Example: `affects=package1,package2@1.0.0,package3@2.0.0` or `affects[]=package1&affects[]=package2@1.0.0`
        :type affects: SecurityAdvisoriesListGlobalAdvisoriesAffectsParameter
        :param published: If specified, only return advisories that were published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type published: str
        :param updated: If specified, only return advisories that were updated on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type updated: str
        :param modified: If specified, only show advisories that were updated or published on a date or date range.  For more information on the syntax of the date range, see \"[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates).\"
        :type modified: str
        :param epss_percentage: If specified, only return advisories that have an EPSS percentage score that matches the provided value. The EPSS percentage represents the likelihood of a CVE being exploited.
        :type epss_percentage: str
        :param epss_percentile: If specified, only return advisories that have an EPSS percentile score that matches the provided value. The EPSS percentile represents the relative rank of the CVE's likelihood of being exploited compared to other CVEs.
        :type epss_percentile: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param per_page: The number of results per page (max 100). For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param sort: The property to sort the results by.
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_global_advisories_serialize(
            ghsa_id=ghsa_id,
            type=type,
            cve_id=cve_id,
            ecosystem=ecosystem,
            severity=severity,
            cwes=cwes,
            is_withdrawn=is_withdrawn,
            affects=affects,
            published=published,
            updated=updated,
            modified=modified,
            epss_percentage=epss_percentage,
            epss_percentile=epss_percentile,
            before=before,
            after=after,
            direction=direction,
            per_page=per_page,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GlobalAdvisory]",
            '429': "BasicError",
            '422': "ValidationErrorSimple",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_list_global_advisories_serialize(
        self,
        ghsa_id,
        type,
        cve_id,
        ecosystem,
        severity,
        cwes,
        is_withdrawn,
        affects,
        published,
        updated,
        modified,
        epss_percentage,
        epss_percentile,
        before,
        after,
        direction,
        per_page,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if ghsa_id is not None:
            
            _query_params.append(('ghsa_id', ghsa_id))
            
        if type is not None:
            
            _query_params.append(('type', type))
            
        if cve_id is not None:
            
            _query_params.append(('cve_id', cve_id))
            
        if ecosystem is not None:
            
            _query_params.append(('ecosystem', ecosystem.value))
            
        if severity is not None:
            
            _query_params.append(('severity', severity))
            
        if cwes is not None:
            
            _query_params.append(('cwes', cwes))
            
        if is_withdrawn is not None:
            
            _query_params.append(('is_withdrawn', is_withdrawn))
            
        if affects is not None:
            
            _query_params.append(('affects', affects))
            
        if published is not None:
            
            _query_params.append(('published', published))
            
        if updated is not None:
            
            _query_params.append(('updated', updated))
            
        if modified is not None:
            
            _query_params.append(('modified', modified))
            
        if epss_percentage is not None:
            
            _query_params.append(('epss_percentage', epss_percentage))
            
        if epss_percentile is not None:
            
            _query_params.append(('epss_percentile', epss_percentile))
            
        if before is not None:
            
            _query_params.append(('before', before))
            
        if after is not None:
            
            _query_params.append(('after', after))
            
        if direction is not None:
            
            _query_params.append(('direction', direction))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/advisories',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_list_org_repository_advisories(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter by the state of the repository advisories. Only advisories of this state will be returned.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RepositoryAdvisory]:
        """List repository security advisories for an organization

        Lists repository security advisories for an organization.  The authenticated user must be an owner or security manager for the organization to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param sort: The property to sort the results by.
        :type sort: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param per_page: The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param state: Filter by the state of the repository advisories. Only advisories of this state will be returned.
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_org_repository_advisories_serialize(
            org=org,
            direction=direction,
            sort=sort,
            before=before,
            after=after,
            per_page=per_page,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RepositoryAdvisory]",
            '400': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_list_org_repository_advisories_with_http_info(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter by the state of the repository advisories. Only advisories of this state will be returned.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RepositoryAdvisory]]:
        """List repository security advisories for an organization

        Lists repository security advisories for an organization.  The authenticated user must be an owner or security manager for the organization to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param sort: The property to sort the results by.
        :type sort: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param per_page: The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param state: Filter by the state of the repository advisories. Only advisories of this state will be returned.
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_org_repository_advisories_serialize(
            org=org,
            direction=direction,
            sort=sort,
            before=before,
            after=after,
            per_page=per_page,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RepositoryAdvisory]",
            '400': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_list_org_repository_advisories_without_preload_content(
        self,
        org: Annotated[StrictStr, Field(description="The organization name. The name is not case sensitive.")],
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter by the state of the repository advisories. Only advisories of this state will be returned.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List repository security advisories for an organization

        Lists repository security advisories for an organization.  The authenticated user must be an owner or security manager for the organization to use this endpoint.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param org: The organization name. The name is not case sensitive. (required)
        :type org: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param sort: The property to sort the results by.
        :type sort: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param per_page: The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param state: Filter by the state of the repository advisories. Only advisories of this state will be returned.
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_org_repository_advisories_serialize(
            org=org,
            direction=direction,
            sort=sort,
            before=before,
            after=after,
            per_page=per_page,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RepositoryAdvisory]",
            '400': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_list_org_repository_advisories_serialize(
        self,
        org,
        direction,
        sort,
        before,
        after,
        per_page,
        state,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if direction is not None:
            
            _query_params.append(('direction', direction))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if before is not None:
            
            _query_params.append(('before', before))
            
        if after is not None:
            
            _query_params.append(('after', after))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if state is not None:
            
            _query_params.append(('state', state))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/scim+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/orgs/{org}/security-advisories',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_list_repository_advisories(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter by state of the repository advisories. Only advisories of this state will be returned.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RepositoryAdvisory]:
        """List repository security advisories

        Lists security advisories in a repository.  The authenticated user can access unpublished security advisories from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on any security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param sort: The property to sort the results by.
        :type sort: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param per_page: The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param state: Filter by state of the repository advisories. Only advisories of this state will be returned.
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_repository_advisories_serialize(
            owner=owner,
            repo=repo,
            direction=direction,
            sort=sort,
            before=before,
            after=after,
            per_page=per_page,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RepositoryAdvisory]",
            '400': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_list_repository_advisories_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter by state of the repository advisories. Only advisories of this state will be returned.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RepositoryAdvisory]]:
        """List repository security advisories

        Lists security advisories in a repository.  The authenticated user can access unpublished security advisories from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on any security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param sort: The property to sort the results by.
        :type sort: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param per_page: The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param state: Filter by state of the repository advisories. Only advisories of this state will be returned.
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_repository_advisories_serialize(
            owner=owner,
            repo=repo,
            direction=direction,
            sort=sort,
            before=before,
            after=after,
            per_page=per_page,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RepositoryAdvisory]",
            '400': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_list_repository_advisories_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        direction: Annotated[Optional[StrictStr], Field(description="The direction to sort the results by.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The property to sort the results by.")] = None,
        before: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        after: Annotated[Optional[StrictStr], Field(description="A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        per_page: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter by state of the repository advisories. Only advisories of this state will be returned.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List repository security advisories

        Lists security advisories in a repository.  The authenticated user can access unpublished security advisories from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on any security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param direction: The direction to sort the results by.
        :type direction: str
        :param sort: The property to sort the results by.
        :type sort: str
        :param before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type before: str
        :param after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type after: str
        :param per_page: The number of advisories to return per page. For more information, see \"[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api).\"
        :type per_page: int
        :param state: Filter by state of the repository advisories. Only advisories of this state will be returned.
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_list_repository_advisories_serialize(
            owner=owner,
            repo=repo,
            direction=direction,
            sort=sort,
            before=before,
            after=after,
            per_page=per_page,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RepositoryAdvisory]",
            '400': "BasicError",
            '404': "BasicError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_list_repository_advisories_serialize(
        self,
        owner,
        repo,
        direction,
        sort,
        before,
        after,
        per_page,
        state,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        # process the query parameters
        if direction is not None:
            
            _query_params.append(('direction', direction))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if before is not None:
            
            _query_params.append(('before', before))
            
        if after is not None:
            
            _query_params.append(('after', after))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if state is not None:
            
            _query_params.append(('state', state))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/scim+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/repos/{owner}/{repo}/security-advisories',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def security_advisories_update_repository_advisory(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        repository_advisory_update: RepositoryAdvisoryUpdate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RepositoryAdvisory:
        """Update a repository security advisory

        Update a repository security advisory using its GitHub Security Advisory (GHSA) identifier.  In order to update any security advisory, the authenticated user must be a security manager or administrator of that repository, or a collaborator on the repository security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param repository_advisory_update: (required)
        :type repository_advisory_update: RepositoryAdvisoryUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_update_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            repository_advisory_update=repository_advisory_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def security_advisories_update_repository_advisory_with_http_info(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        repository_advisory_update: RepositoryAdvisoryUpdate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RepositoryAdvisory]:
        """Update a repository security advisory

        Update a repository security advisory using its GitHub Security Advisory (GHSA) identifier.  In order to update any security advisory, the authenticated user must be a security manager or administrator of that repository, or a collaborator on the repository security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param repository_advisory_update: (required)
        :type repository_advisory_update: RepositoryAdvisoryUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_update_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            repository_advisory_update=repository_advisory_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def security_advisories_update_repository_advisory_without_preload_content(
        self,
        owner: Annotated[StrictStr, Field(description="The account owner of the repository. The name is not case sensitive.")],
        repo: Annotated[StrictStr, Field(description="The name of the repository without the `.git` extension. The name is not case sensitive.")],
        ghsa_id: Annotated[StrictStr, Field(description="The GHSA (GitHub Security Advisory) identifier of the advisory.")],
        repository_advisory_update: RepositoryAdvisoryUpdate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a repository security advisory

        Update a repository security advisory using its GitHub Security Advisory (GHSA) identifier.  In order to update any security advisory, the authenticated user must be a security manager or administrator of that repository, or a collaborator on the repository security advisory.  OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        :param owner: The account owner of the repository. The name is not case sensitive. (required)
        :type owner: str
        :param repo: The name of the repository without the `.git` extension. The name is not case sensitive. (required)
        :type repo: str
        :param ghsa_id: The GHSA (GitHub Security Advisory) identifier of the advisory. (required)
        :type ghsa_id: str
        :param repository_advisory_update: (required)
        :type repository_advisory_update: RepositoryAdvisoryUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._security_advisories_update_repository_advisory_serialize(
            owner=owner,
            repo=repo,
            ghsa_id=ghsa_id,
            repository_advisory_update=repository_advisory_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryAdvisory",
            '403': "BasicError",
            '404': "BasicError",
            '422': "ValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _security_advisories_update_repository_advisory_serialize(
        self,
        owner,
        repo,
        ghsa_id,
        repository_advisory_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if owner is not None:
            _path_params['owner'] = owner
        if repo is not None:
            _path_params['repo'] = repo
        if ghsa_id is not None:
            _path_params['ghsa_id'] = ghsa_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if repository_advisory_update is not None:
            _body_params = repository_advisory_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/repos/{owner}/{repo}/security-advisories/{ghsa_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


