# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ActionsBillingUsageMinutesUsedBreakdown(BaseModel):
    """
    ActionsBillingUsageMinutesUsedBreakdown
    """ # noqa: E501
    ubuntu: Optional[StrictInt] = Field(default=None, description="Total minutes used on Ubuntu runner machines.", alias="UBUNTU")
    macos: Optional[StrictInt] = Field(default=None, description="Total minutes used on macOS runner machines.", alias="MACOS")
    windows: Optional[StrictInt] = Field(default=None, description="Total minutes used on Windows runner machines.", alias="WINDOWS")
    ubuntu_4_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Ubuntu 4 core runner machines.")
    ubuntu_8_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Ubuntu 8 core runner machines.")
    ubuntu_16_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Ubuntu 16 core runner machines.")
    ubuntu_32_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Ubuntu 32 core runner machines.")
    ubuntu_64_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Ubuntu 64 core runner machines.")
    windows_4_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Windows 4 core runner machines.")
    windows_8_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Windows 8 core runner machines.")
    windows_16_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Windows 16 core runner machines.")
    windows_32_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Windows 32 core runner machines.")
    windows_64_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on Windows 64 core runner machines.")
    macos_12_core: Optional[StrictInt] = Field(default=None, description="Total minutes used on macOS 12 core runner machines.")
    total: Optional[StrictInt] = Field(default=None, description="Total minutes used on all runner machines.")
    __properties: ClassVar[List[str]] = ["UBUNTU", "MACOS", "WINDOWS", "ubuntu_4_core", "ubuntu_8_core", "ubuntu_16_core", "ubuntu_32_core", "ubuntu_64_core", "windows_4_core", "windows_8_core", "windows_16_core", "windows_32_core", "windows_64_core", "macos_12_core", "total"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActionsBillingUsageMinutesUsedBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActionsBillingUsageMinutesUsedBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "UBUNTU": obj.get("UBUNTU"),
            "MACOS": obj.get("MACOS"),
            "WINDOWS": obj.get("WINDOWS"),
            "ubuntu_4_core": obj.get("ubuntu_4_core"),
            "ubuntu_8_core": obj.get("ubuntu_8_core"),
            "ubuntu_16_core": obj.get("ubuntu_16_core"),
            "ubuntu_32_core": obj.get("ubuntu_32_core"),
            "ubuntu_64_core": obj.get("ubuntu_64_core"),
            "windows_4_core": obj.get("windows_4_core"),
            "windows_8_core": obj.get("windows_8_core"),
            "windows_16_core": obj.get("windows_16_core"),
            "windows_32_core": obj.get("windows_32_core"),
            "windows_64_core": obj.get("windows_64_core"),
            "macos_12_core": obj.get("macos_12_core"),
            "total": obj.get("total")
        })
        return _obj


