# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ActionsCreateSelfHostedRunnerGroupForOrgRequest(BaseModel):
    """
    ActionsCreateSelfHostedRunnerGroupForOrgRequest
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the runner group.")
    visibility: Optional[StrictStr] = Field(default='all', description="Visibility of a runner group. You can select all repositories, select individual repositories, or limit access to private repositories.")
    selected_repository_ids: Optional[List[StrictInt]] = Field(default=None, description="List of repository IDs that can access the runner group.")
    runners: Optional[List[StrictInt]] = Field(default=None, description="List of runner IDs to add to the runner group.")
    allows_public_repositories: Optional[StrictBool] = Field(default=False, description="Whether the runner group can be used by `public` repositories.")
    restricted_to_workflows: Optional[StrictBool] = Field(default=False, description="If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.")
    selected_workflows: Optional[List[StrictStr]] = Field(default=None, description="List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`.")
    network_configuration_id: Optional[StrictStr] = Field(default=None, description="The identifier of a hosted compute network configuration.")
    __properties: ClassVar[List[str]] = ["name", "visibility", "selected_repository_ids", "runners", "allows_public_repositories", "restricted_to_workflows", "selected_workflows", "network_configuration_id"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['selected', 'all', 'private']):
            raise ValueError("must be one of enum values ('selected', 'all', 'private')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActionsCreateSelfHostedRunnerGroupForOrgRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActionsCreateSelfHostedRunnerGroupForOrgRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'all',
            "selected_repository_ids": obj.get("selected_repository_ids"),
            "runners": obj.get("runners"),
            "allows_public_repositories": obj.get("allows_public_repositories") if obj.get("allows_public_repositories") is not None else False,
            "restricted_to_workflows": obj.get("restricted_to_workflows") if obj.get("restricted_to_workflows") is not None else False,
            "selected_workflows": obj.get("selected_workflows"),
            "network_configuration_id": obj.get("network_configuration_id")
        })
        return _obj


