# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class ActionsForkPrWorkflowsPrivateRepos(BaseModel):
    """
    ActionsForkPrWorkflowsPrivateRepos
    """ # noqa: E501
    run_workflows_from_fork_pull_requests: StrictBool = Field(description="Whether workflows triggered by pull requests from forks are allowed to run on private repositories.")
    send_write_tokens_to_workflows: StrictBool = Field(description="Whether GitHub Actions can create pull requests or submit approving pull request reviews from a workflow triggered by a fork pull request.")
    send_secrets_and_variables: StrictBool = Field(description="Whether to make secrets and variables available to workflows triggered by pull requests from forks.")
    require_approval_for_fork_pr_workflows: StrictBool = Field(description="Whether workflows triggered by pull requests from forks require approval from a repository administrator to run.")
    __properties: ClassVar[List[str]] = ["run_workflows_from_fork_pull_requests", "send_write_tokens_to_workflows", "send_secrets_and_variables", "require_approval_for_fork_pr_workflows"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActionsForkPrWorkflowsPrivateRepos from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActionsForkPrWorkflowsPrivateRepos from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "run_workflows_from_fork_pull_requests": obj.get("run_workflows_from_fork_pull_requests"),
            "send_write_tokens_to_workflows": obj.get("send_write_tokens_to_workflows"),
            "send_secrets_and_variables": obj.get("send_secrets_and_variables"),
            "require_approval_for_fork_pr_workflows": obj.get("require_approval_for_fork_pr_workflows")
        })
        return _obj


