# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.actions_hosted_runner_machine_spec import ActionsHostedRunnerMachineSpec
from devopso.clients.github.models.nullable_actions_hosted_runner_pool_image import NullableActionsHostedRunnerPoolImage
from devopso.clients.github.models.public_ip import PublicIp
from typing import Optional, Set
from typing_extensions import Self

class ActionsHostedRunner(BaseModel):
    """
    A Github-hosted hosted runner.
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier of the hosted runner.")
    name: StrictStr = Field(description="The name of the hosted runner.")
    runner_group_id: Optional[StrictInt] = Field(default=None, description="The unique identifier of the group that the hosted runner belongs to.")
    image_details: Optional[NullableActionsHostedRunnerPoolImage]
    machine_size_details: ActionsHostedRunnerMachineSpec
    status: StrictStr = Field(description="The status of the runner.")
    platform: StrictStr = Field(description="The operating system of the image.")
    maximum_runners: Optional[StrictInt] = Field(default=10, description="The maximum amount of hosted runners. Runners will not scale automatically above this number. Use this setting to limit your cost.")
    public_ip_enabled: StrictBool = Field(description="Whether public IP is enabled for the hosted runners.")
    public_ips: Optional[List[PublicIp]] = Field(default=None, description="The public IP ranges when public IP is enabled for the hosted runners.")
    last_active_on: Optional[datetime] = Field(default=None, description="The time at which the runner was last used, in ISO 8601 format.")
    __properties: ClassVar[List[str]] = ["id", "name", "runner_group_id", "image_details", "machine_size_details", "status", "platform", "maximum_runners", "public_ip_enabled", "public_ips", "last_active_on"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Ready', 'Provisioning', 'Shutdown', 'Deleting', 'Stuck']):
            raise ValueError("must be one of enum values ('Ready', 'Provisioning', 'Shutdown', 'Deleting', 'Stuck')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActionsHostedRunner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image_details
        if self.image_details:
            _dict['image_details'] = self.image_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of machine_size_details
        if self.machine_size_details:
            _dict['machine_size_details'] = self.machine_size_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in public_ips (list)
        _items = []
        if self.public_ips:
            for _item_public_ips in self.public_ips:
                if _item_public_ips:
                    _items.append(_item_public_ips.to_dict())
            _dict['public_ips'] = _items
        # set to None if image_details (nullable) is None
        # and model_fields_set contains the field
        if self.image_details is None and "image_details" in self.model_fields_set:
            _dict['image_details'] = None

        # set to None if last_active_on (nullable) is None
        # and model_fields_set contains the field
        if self.last_active_on is None and "last_active_on" in self.model_fields_set:
            _dict['last_active_on'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActionsHostedRunner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "runner_group_id": obj.get("runner_group_id"),
            "image_details": NullableActionsHostedRunnerPoolImage.from_dict(obj["image_details"]) if obj.get("image_details") is not None else None,
            "machine_size_details": ActionsHostedRunnerMachineSpec.from_dict(obj["machine_size_details"]) if obj.get("machine_size_details") is not None else None,
            "status": obj.get("status"),
            "platform": obj.get("platform"),
            "maximum_runners": obj.get("maximum_runners") if obj.get("maximum_runners") is not None else 10,
            "public_ip_enabled": obj.get("public_ip_enabled"),
            "public_ips": [PublicIp.from_dict(_item) for _item in obj["public_ips"]] if obj.get("public_ips") is not None else None,
            "last_active_on": obj.get("last_active_on")
        })
        return _obj


