# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from typing import Optional, Set
from typing_extensions import Self

class Activity(BaseModel):
    """
    Activity
    """ # noqa: E501
    id: StrictInt
    node_id: StrictStr
    before: StrictStr = Field(description="The SHA of the commit before the activity.")
    after: StrictStr = Field(description="The SHA of the commit after the activity.")
    ref: StrictStr = Field(description="The full Git reference, formatted as `refs/heads/<branch name>`.")
    timestamp: datetime = Field(description="The time when the activity occurred.")
    activity_type: StrictStr = Field(description="The type of the activity that was performed.")
    actor: Optional[NullableSimpleUser]
    __properties: ClassVar[List[str]] = ["id", "node_id", "before", "after", "ref", "timestamp", "activity_type", "actor"]

    @field_validator('activity_type')
    def activity_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['push', 'force_push', 'branch_deletion', 'branch_creation', 'pr_merge', 'merge_queue_merge']):
            raise ValueError("must be one of enum values ('push', 'force_push', 'branch_deletion', 'branch_creation', 'pr_merge', 'merge_queue_merge')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Activity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # set to None if actor (nullable) is None
        # and model_fields_set contains the field
        if self.actor is None and "actor" in self.model_fields_set:
            _dict['actor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Activity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "before": obj.get("before"),
            "after": obj.get("after"),
            "ref": obj.get("ref"),
            "timestamp": obj.get("timestamp"),
            "activity_type": obj.get("activity_type"),
            "actor": NullableSimpleUser.from_dict(obj["actor"]) if obj.get("actor") is not None else None
        })
        return _obj


