# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.alert_instance_location import AlertInstanceLocation
from devopso.clients.github.models.code_scanning_alert_instance_message import CodeScanningAlertInstanceMessage
from typing import Optional, Set
from typing_extensions import Self

class AlertInstance(BaseModel):
    """
    AlertInstance
    """ # noqa: E501
    analysis_key: StrictStr = Field(description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.")
    category: Optional[StrictStr] = Field(default=None, description="Identifies the configuration under which the analysis was executed.")
    classifications: Optional[List[StrictStr]] = None
    commit_sha: Optional[StrictStr] = None
    environment: StrictStr = Field(description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.")
    location: Optional[AlertInstanceLocation] = None
    message: Optional[CodeScanningAlertInstanceMessage] = None
    ref: StrictStr = Field(description="The full Git reference, formatted as `refs/heads/<branch name>`.")
    state: StrictStr = Field(description="State of a code scanning alert.")
    __properties: ClassVar[List[str]] = ["analysis_key", "category", "classifications", "commit_sha", "environment", "location", "message", "ref", "state"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['open', 'dismissed', 'fixed']):
            raise ValueError("must be one of enum values ('open', 'dismissed', 'fixed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AlertInstance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict['message'] = self.message.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AlertInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "analysis_key": obj.get("analysis_key"),
            "category": obj.get("category"),
            "classifications": obj.get("classifications"),
            "commit_sha": obj.get("commit_sha"),
            "environment": obj.get("environment"),
            "location": AlertInstanceLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "message": CodeScanningAlertInstanceMessage.from_dict(obj["message"]) if obj.get("message") is not None else None,
            "ref": obj.get("ref"),
            "state": obj.get("state")
        })
        return _obj


