# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.api_overview_domains_actions_inbound import ApiOverviewDomainsActionsInbound
from devopso.clients.github.models.api_overview_domains_artifact_attestations import ApiOverviewDomainsArtifactAttestations
from typing import Optional, Set
from typing_extensions import Self

class ApiOverviewDomains(BaseModel):
    """
    ApiOverviewDomains
    """ # noqa: E501
    website: Optional[List[StrictStr]] = None
    codespaces: Optional[List[StrictStr]] = None
    copilot: Optional[List[StrictStr]] = None
    packages: Optional[List[StrictStr]] = None
    actions: Optional[List[StrictStr]] = None
    actions_inbound: Optional[ApiOverviewDomainsActionsInbound] = None
    artifact_attestations: Optional[ApiOverviewDomainsArtifactAttestations] = None
    __properties: ClassVar[List[str]] = ["website", "codespaces", "copilot", "packages", "actions", "actions_inbound", "artifact_attestations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiOverviewDomains from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of actions_inbound
        if self.actions_inbound:
            _dict['actions_inbound'] = self.actions_inbound.to_dict()
        # override the default output from pydantic by calling `to_dict()` of artifact_attestations
        if self.artifact_attestations:
            _dict['artifact_attestations'] = self.artifact_attestations.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiOverviewDomains from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "website": obj.get("website"),
            "codespaces": obj.get("codespaces"),
            "copilot": obj.get("copilot"),
            "packages": obj.get("packages"),
            "actions": obj.get("actions"),
            "actions_inbound": ApiOverviewDomainsActionsInbound.from_dict(obj["actions_inbound"]) if obj.get("actions_inbound") is not None else None,
            "artifact_attestations": ApiOverviewDomainsArtifactAttestations.from_dict(obj["artifact_attestations"]) if obj.get("artifact_attestations") is not None else None
        })
        return _obj


