# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class App2Permissions(BaseModel):
    """
    The set of permissions for the GitHub app
    """ # noqa: E501
    actions: Optional[StrictStr] = None
    administration: Optional[StrictStr] = None
    checks: Optional[StrictStr] = None
    content_references: Optional[StrictStr] = None
    contents: Optional[StrictStr] = None
    deployments: Optional[StrictStr] = None
    discussions: Optional[StrictStr] = None
    emails: Optional[StrictStr] = None
    environments: Optional[StrictStr] = None
    issues: Optional[StrictStr] = None
    keys: Optional[StrictStr] = None
    members: Optional[StrictStr] = None
    metadata: Optional[StrictStr] = None
    organization_administration: Optional[StrictStr] = None
    organization_hooks: Optional[StrictStr] = None
    organization_packages: Optional[StrictStr] = None
    organization_plan: Optional[StrictStr] = None
    organization_projects: Optional[StrictStr] = None
    organization_secrets: Optional[StrictStr] = None
    organization_self_hosted_runners: Optional[StrictStr] = None
    organization_user_blocking: Optional[StrictStr] = None
    packages: Optional[StrictStr] = None
    pages: Optional[StrictStr] = None
    pull_requests: Optional[StrictStr] = None
    repository_hooks: Optional[StrictStr] = None
    repository_projects: Optional[StrictStr] = None
    secret_scanning_alerts: Optional[StrictStr] = None
    secrets: Optional[StrictStr] = None
    security_events: Optional[StrictStr] = None
    security_scanning_alert: Optional[StrictStr] = None
    single_file: Optional[StrictStr] = None
    statuses: Optional[StrictStr] = None
    team_discussions: Optional[StrictStr] = None
    vulnerability_alerts: Optional[StrictStr] = None
    workflows: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["actions", "administration", "checks", "content_references", "contents", "deployments", "discussions", "emails", "environments", "issues", "keys", "members", "metadata", "organization_administration", "organization_hooks", "organization_packages", "organization_plan", "organization_projects", "organization_secrets", "organization_self_hosted_runners", "organization_user_blocking", "packages", "pages", "pull_requests", "repository_hooks", "repository_projects", "secret_scanning_alerts", "secrets", "security_events", "security_scanning_alert", "single_file", "statuses", "team_discussions", "vulnerability_alerts", "workflows"]

    @field_validator('actions')
    def actions_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('administration')
    def administration_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('checks')
    def checks_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('content_references')
    def content_references_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('contents')
    def contents_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('deployments')
    def deployments_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('discussions')
    def discussions_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('emails')
    def emails_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('environments')
    def environments_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('issues')
    def issues_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('keys')
    def keys_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('members')
    def members_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('metadata')
    def metadata_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('organization_administration')
    def organization_administration_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('organization_hooks')
    def organization_hooks_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('organization_packages')
    def organization_packages_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('organization_plan')
    def organization_plan_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('organization_projects')
    def organization_projects_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write', 'admin']):
            raise ValueError("must be one of enum values ('read', 'write', 'admin')")
        return value

    @field_validator('organization_secrets')
    def organization_secrets_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('organization_self_hosted_runners')
    def organization_self_hosted_runners_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('organization_user_blocking')
    def organization_user_blocking_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('packages')
    def packages_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('pages')
    def pages_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('pull_requests')
    def pull_requests_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('repository_hooks')
    def repository_hooks_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('repository_projects')
    def repository_projects_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write', 'admin']):
            raise ValueError("must be one of enum values ('read', 'write', 'admin')")
        return value

    @field_validator('secret_scanning_alerts')
    def secret_scanning_alerts_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('secrets')
    def secrets_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('security_events')
    def security_events_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('security_scanning_alert')
    def security_scanning_alert_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('single_file')
    def single_file_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('statuses')
    def statuses_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('team_discussions')
    def team_discussions_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('vulnerability_alerts')
    def vulnerability_alerts_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    @field_validator('workflows')
    def workflows_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write']):
            raise ValueError("must be one of enum values ('read', 'write')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of App2Permissions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of App2Permissions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actions": obj.get("actions"),
            "administration": obj.get("administration"),
            "checks": obj.get("checks"),
            "content_references": obj.get("content_references"),
            "contents": obj.get("contents"),
            "deployments": obj.get("deployments"),
            "discussions": obj.get("discussions"),
            "emails": obj.get("emails"),
            "environments": obj.get("environments"),
            "issues": obj.get("issues"),
            "keys": obj.get("keys"),
            "members": obj.get("members"),
            "metadata": obj.get("metadata"),
            "organization_administration": obj.get("organization_administration"),
            "organization_hooks": obj.get("organization_hooks"),
            "organization_packages": obj.get("organization_packages"),
            "organization_plan": obj.get("organization_plan"),
            "organization_projects": obj.get("organization_projects"),
            "organization_secrets": obj.get("organization_secrets"),
            "organization_self_hosted_runners": obj.get("organization_self_hosted_runners"),
            "organization_user_blocking": obj.get("organization_user_blocking"),
            "packages": obj.get("packages"),
            "pages": obj.get("pages"),
            "pull_requests": obj.get("pull_requests"),
            "repository_hooks": obj.get("repository_hooks"),
            "repository_projects": obj.get("repository_projects"),
            "secret_scanning_alerts": obj.get("secret_scanning_alerts"),
            "secrets": obj.get("secrets"),
            "security_events": obj.get("security_events"),
            "security_scanning_alert": obj.get("security_scanning_alert"),
            "single_file": obj.get("single_file"),
            "statuses": obj.get("statuses"),
            "team_discussions": obj.get("team_discussions"),
            "vulnerability_alerts": obj.get("vulnerability_alerts"),
            "workflows": obj.get("workflows")
        })
        return _obj


