# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.integration_owner import IntegrationOwner
from devopso.clients.github.models.integration_permissions import IntegrationPermissions
from typing import Optional, Set
from typing_extensions import Self

class AppsCreateFromManifest201Response(BaseModel):
    """
    AppsCreateFromManifest201Response
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier of the GitHub app")
    slug: Optional[StrictStr] = Field(default=None, description="The slug name of the GitHub app")
    node_id: StrictStr
    client_id: StrictStr
    owner: IntegrationOwner
    name: StrictStr = Field(description="The name of the GitHub app")
    description: Optional[StrictStr]
    external_url: StrictStr
    html_url: StrictStr
    created_at: datetime
    updated_at: datetime
    permissions: IntegrationPermissions
    events: List[StrictStr] = Field(description="The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.")
    installations_count: Optional[StrictInt] = Field(default=None, description="The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.")
    client_secret: StrictStr
    webhook_secret: Optional[StrictStr]
    pem: StrictStr
    __properties: ClassVar[List[str]] = ["id", "slug", "node_id", "client_id", "owner", "name", "description", "external_url", "html_url", "created_at", "updated_at", "permissions", "events", "installations_count", "client_secret", "webhook_secret", "pem"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppsCreateFromManifest201Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if webhook_secret (nullable) is None
        # and model_fields_set contains the field
        if self.webhook_secret is None and "webhook_secret" in self.model_fields_set:
            _dict['webhook_secret'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppsCreateFromManifest201Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "slug": obj.get("slug"),
            "node_id": obj.get("node_id"),
            "client_id": obj.get("client_id"),
            "owner": IntegrationOwner.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "external_url": obj.get("external_url"),
            "html_url": obj.get("html_url"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "permissions": IntegrationPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "events": obj.get("events"),
            "installations_count": obj.get("installations_count"),
            "client_secret": obj.get("client_secret"),
            "webhook_secret": obj.get("webhook_secret"),
            "pem": obj.get("pem")
        })
        return _obj


