# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.app_permissions import AppPermissions
from typing import Optional, Set
from typing_extensions import Self

class AppsScopeTokenRequest(BaseModel):
    """
    AppsScopeTokenRequest
    """ # noqa: E501
    access_token: StrictStr = Field(description="The access token used to authenticate to the GitHub API.")
    target: Optional[StrictStr] = Field(default=None, description="The name of the user or organization to scope the user access token to. **Required** unless `target_id` is specified.")
    target_id: Optional[StrictInt] = Field(default=None, description="The ID of the user or organization to scope the user access token to. **Required** unless `target` is specified.")
    repositories: Optional[List[StrictStr]] = Field(default=None, description="The list of repository names to scope the user access token to. `repositories` may not be specified if `repository_ids` is specified.")
    repository_ids: Optional[List[StrictInt]] = Field(default=None, description="The list of repository IDs to scope the user access token to. `repository_ids` may not be specified if `repositories` is specified.")
    permissions: Optional[AppPermissions] = None
    __properties: ClassVar[List[str]] = ["access_token", "target", "target_id", "repositories", "repository_ids", "permissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppsScopeTokenRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppsScopeTokenRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "access_token": obj.get("access_token"),
            "target": obj.get("target"),
            "target_id": obj.get("target_id"),
            "repositories": obj.get("repositories"),
            "repository_ids": obj.get("repository_ids"),
            "permissions": AppPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None
        })
        return _obj


