# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.repository import Repository
from typing import Optional, Set
from typing_extensions import Self

class AuthenticationToken(BaseModel):
    """
    Authentication Token
    """ # noqa: E501
    token: StrictStr = Field(description="The token used for authentication")
    expires_at: datetime = Field(description="The time this token expires")
    permissions: Optional[Dict[str, Any]] = None
    repositories: Optional[List[Repository]] = Field(default=None, description="The repositories this token has access to")
    single_file: Optional[StrictStr] = None
    repository_selection: Optional[StrictStr] = Field(default=None, description="Describe whether all repositories have been selected or there's a selection involved")
    __properties: ClassVar[List[str]] = ["token", "expires_at", "permissions", "repositories", "single_file", "repository_selection"]

    @field_validator('repository_selection')
    def repository_selection_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['all', 'selected']):
            raise ValueError("must be one of enum values ('all', 'selected')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthenticationToken from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in repositories (list)
        _items = []
        if self.repositories:
            for _item_repositories in self.repositories:
                if _item_repositories:
                    _items.append(_item_repositories.to_dict())
            _dict['repositories'] = _items
        # set to None if single_file (nullable) is None
        # and model_fields_set contains the field
        if self.single_file is None and "single_file" in self.model_fields_set:
            _dict['single_file'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthenticationToken from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "token": obj.get("token"),
            "expires_at": obj.get("expires_at"),
            "permissions": obj.get("permissions"),
            "repositories": [Repository.from_dict(_item) for _item in obj["repositories"]] if obj.get("repositories") is not None else None,
            "single_file": obj.get("single_file"),
            "repository_selection": obj.get("repository_selection")
        })
        return _obj


