# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.authorization_app import AuthorizationApp
from devopso.clients.github.models.nullable_scoped_installation import NullableScopedInstallation
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from typing import Optional, Set
from typing_extensions import Self

class Authorization(BaseModel):
    """
    The authorization for an OAuth app, GitHub App, or a Personal Access Token.
    """ # noqa: E501
    id: StrictInt
    url: StrictStr
    scopes: Optional[List[StrictStr]] = Field(description="A list of scopes that this authorization is in.")
    token: StrictStr
    token_last_eight: Optional[StrictStr]
    hashed_token: Optional[StrictStr]
    app: AuthorizationApp
    note: Optional[StrictStr]
    note_url: Optional[StrictStr]
    updated_at: datetime
    created_at: datetime
    fingerprint: Optional[StrictStr]
    user: Optional[NullableSimpleUser] = None
    installation: Optional[NullableScopedInstallation] = None
    expires_at: Optional[datetime]
    __properties: ClassVar[List[str]] = ["id", "url", "scopes", "token", "token_last_eight", "hashed_token", "app", "note", "note_url", "updated_at", "created_at", "fingerprint", "user", "installation", "expires_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Authorization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['app'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of installation
        if self.installation:
            _dict['installation'] = self.installation.to_dict()
        # set to None if scopes (nullable) is None
        # and model_fields_set contains the field
        if self.scopes is None and "scopes" in self.model_fields_set:
            _dict['scopes'] = None

        # set to None if token_last_eight (nullable) is None
        # and model_fields_set contains the field
        if self.token_last_eight is None and "token_last_eight" in self.model_fields_set:
            _dict['token_last_eight'] = None

        # set to None if hashed_token (nullable) is None
        # and model_fields_set contains the field
        if self.hashed_token is None and "hashed_token" in self.model_fields_set:
            _dict['hashed_token'] = None

        # set to None if note (nullable) is None
        # and model_fields_set contains the field
        if self.note is None and "note" in self.model_fields_set:
            _dict['note'] = None

        # set to None if note_url (nullable) is None
        # and model_fields_set contains the field
        if self.note_url is None and "note_url" in self.model_fields_set:
            _dict['note_url'] = None

        # set to None if fingerprint (nullable) is None
        # and model_fields_set contains the field
        if self.fingerprint is None and "fingerprint" in self.model_fields_set:
            _dict['fingerprint'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        # set to None if installation (nullable) is None
        # and model_fields_set contains the field
        if self.installation is None and "installation" in self.model_fields_set:
            _dict['installation'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expires_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Authorization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "url": obj.get("url"),
            "scopes": obj.get("scopes"),
            "token": obj.get("token"),
            "token_last_eight": obj.get("token_last_eight"),
            "hashed_token": obj.get("hashed_token"),
            "app": AuthorizationApp.from_dict(obj["app"]) if obj.get("app") is not None else None,
            "note": obj.get("note"),
            "note_url": obj.get("note_url"),
            "updated_at": obj.get("updated_at"),
            "created_at": obj.get("created_at"),
            "fingerprint": obj.get("fingerprint"),
            "user": NullableSimpleUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "installation": NullableScopedInstallation.from_dict(obj["installation"]) if obj.get("installation") is not None else None,
            "expires_at": obj.get("expires_at")
        })
        return _obj


