# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class AutoMerge(BaseModel):
    """
    The status of auto merging a pull request.
    """ # noqa: E501
    enabled_by: SimpleUser
    merge_method: StrictStr = Field(description="The merge method to use.")
    commit_title: StrictStr = Field(description="Title for the merge commit message.")
    commit_message: StrictStr = Field(description="Commit message for the merge commit.")
    __properties: ClassVar[List[str]] = ["enabled_by", "merge_method", "commit_title", "commit_message"]

    @field_validator('merge_method')
    def merge_method_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['merge', 'squash', 'rebase']):
            raise ValueError("must be one of enum values ('merge', 'squash', 'rebase')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AutoMerge from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of enabled_by
        if self.enabled_by:
            _dict['enabled_by'] = self.enabled_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AutoMerge from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled_by": SimpleUser.from_dict(obj["enabled_by"]) if obj.get("enabled_by") is not None else None,
            "merge_method": obj.get("merge_method"),
            "commit_title": obj.get("commit_title"),
            "commit_message": obj.get("commit_message")
        })
        return _obj


