# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class BillingPremiumRequestUsageReportOrgUsageItemsInner(BaseModel):
    """
    BillingPremiumRequestUsageReportOrgUsageItemsInner
    """ # noqa: E501
    product: StrictStr = Field(description="Product name.")
    sku: StrictStr = Field(description="SKU name.")
    model: StrictStr = Field(description="Model name.")
    unit_type: StrictStr = Field(description="Unit type of the usage line item.", alias="unitType")
    price_per_unit: Union[StrictFloat, StrictInt] = Field(description="Price per unit of the usage line item.", alias="pricePerUnit")
    gross_quantity: StrictInt = Field(description="Gross quantity of the usage line item.", alias="grossQuantity")
    gross_amount: Union[StrictFloat, StrictInt] = Field(description="Gross amount of the usage line item.", alias="grossAmount")
    discount_quantity: StrictInt = Field(description="Discount quantity of the usage line item.", alias="discountQuantity")
    discount_amount: Union[StrictFloat, StrictInt] = Field(description="Discount amount of the usage line item.", alias="discountAmount")
    net_quantity: StrictInt = Field(description="Net quantity of the usage line item.", alias="netQuantity")
    net_amount: Union[StrictFloat, StrictInt] = Field(description="Net amount of the usage line item.", alias="netAmount")
    __properties: ClassVar[List[str]] = ["product", "sku", "model", "unitType", "pricePerUnit", "grossQuantity", "grossAmount", "discountQuantity", "discountAmount", "netQuantity", "netAmount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingPremiumRequestUsageReportOrgUsageItemsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingPremiumRequestUsageReportOrgUsageItemsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "product": obj.get("product"),
            "sku": obj.get("sku"),
            "model": obj.get("model"),
            "unitType": obj.get("unitType"),
            "pricePerUnit": obj.get("pricePerUnit"),
            "grossQuantity": obj.get("grossQuantity"),
            "grossAmount": obj.get("grossAmount"),
            "discountQuantity": obj.get("discountQuantity"),
            "discountAmount": obj.get("discountAmount"),
            "netQuantity": obj.get("netQuantity"),
            "netAmount": obj.get("netAmount")
        })
        return _obj


