# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.billing_premium_request_usage_report_org_time_period import BillingPremiumRequestUsageReportOrgTimePeriod
from devopso.clients.github.models.billing_premium_request_usage_report_org_usage_items_inner import BillingPremiumRequestUsageReportOrgUsageItemsInner
from typing import Optional, Set
from typing_extensions import Self

class BillingPremiumRequestUsageReportUser(BaseModel):
    """
    BillingPremiumRequestUsageReportUser
    """ # noqa: E501
    time_period: BillingPremiumRequestUsageReportOrgTimePeriod = Field(alias="timePeriod")
    user: StrictStr = Field(description="The unique identifier of the user.")
    product: Optional[StrictStr] = Field(default=None, description="The product for the usage report.")
    model: Optional[StrictStr] = Field(default=None, description="The model for the usage report.")
    usage_items: List[BillingPremiumRequestUsageReportOrgUsageItemsInner] = Field(alias="usageItems")
    __properties: ClassVar[List[str]] = ["timePeriod", "user", "product", "model", "usageItems"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingPremiumRequestUsageReportUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_period
        if self.time_period:
            _dict['timePeriod'] = self.time_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in usage_items (list)
        _items = []
        if self.usage_items:
            for _item_usage_items in self.usage_items:
                if _item_usage_items:
                    _items.append(_item_usage_items.to_dict())
            _dict['usageItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingPremiumRequestUsageReportUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timePeriod": BillingPremiumRequestUsageReportOrgTimePeriod.from_dict(obj["timePeriod"]) if obj.get("timePeriod") is not None else None,
            "user": obj.get("user"),
            "product": obj.get("product"),
            "model": obj.get("model"),
            "usageItems": [BillingPremiumRequestUsageReportOrgUsageItemsInner.from_dict(_item) for _item in obj["usageItems"]] if obj.get("usageItems") is not None else None
        })
        return _obj


