# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class BillingUsageReportUserUsageItemsInner(BaseModel):
    """
    BillingUsageReportUserUsageItemsInner
    """ # noqa: E501
    var_date: StrictStr = Field(description="Date of the usage line item.", alias="date")
    product: StrictStr = Field(description="Product name.")
    sku: StrictStr = Field(description="SKU name.")
    quantity: StrictInt = Field(description="Quantity of the usage line item.")
    unit_type: StrictStr = Field(description="Unit type of the usage line item.", alias="unitType")
    price_per_unit: Union[StrictFloat, StrictInt] = Field(description="Price per unit of the usage line item.", alias="pricePerUnit")
    gross_amount: Union[StrictFloat, StrictInt] = Field(description="Gross amount of the usage line item.", alias="grossAmount")
    discount_amount: Union[StrictFloat, StrictInt] = Field(description="Discount amount of the usage line item.", alias="discountAmount")
    net_amount: Union[StrictFloat, StrictInt] = Field(description="Net amount of the usage line item.", alias="netAmount")
    repository_name: Optional[StrictStr] = Field(default=None, description="Name of the repository.", alias="repositoryName")
    __properties: ClassVar[List[str]] = ["date", "product", "sku", "quantity", "unitType", "pricePerUnit", "grossAmount", "discountAmount", "netAmount", "repositoryName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingUsageReportUserUsageItemsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingUsageReportUserUsageItemsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date": obj.get("date"),
            "product": obj.get("product"),
            "sku": obj.get("sku"),
            "quantity": obj.get("quantity"),
            "unitType": obj.get("unitType"),
            "pricePerUnit": obj.get("pricePerUnit"),
            "grossAmount": obj.get("grossAmount"),
            "discountAmount": obj.get("discountAmount"),
            "netAmount": obj.get("netAmount"),
            "repositoryName": obj.get("repositoryName")
        })
        return _obj


