# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from devopso.clients.github.models.branch_restriction_policy_apps_inner import BranchRestrictionPolicyAppsInner
from devopso.clients.github.models.branch_restriction_policy_users_inner import BranchRestrictionPolicyUsersInner
from devopso.clients.github.models.team import Team
from typing import Optional, Set
from typing_extensions import Self

class BranchRestrictionPolicy(BaseModel):
    """
    Branch Restriction Policy
    """ # noqa: E501
    url: StrictStr
    users_url: StrictStr
    teams_url: StrictStr
    apps_url: StrictStr
    users: List[BranchRestrictionPolicyUsersInner]
    teams: List[Team]
    apps: List[BranchRestrictionPolicyAppsInner]
    __properties: ClassVar[List[str]] = ["url", "users_url", "teams_url", "apps_url", "users", "teams", "apps"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BranchRestrictionPolicy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teams (list)
        _items = []
        if self.teams:
            for _item_teams in self.teams:
                if _item_teams:
                    _items.append(_item_teams.to_dict())
            _dict['teams'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in apps (list)
        _items = []
        if self.apps:
            for _item_apps in self.apps:
                if _item_apps:
                    _items.append(_item_apps.to_dict())
            _dict['apps'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BranchRestrictionPolicy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "users_url": obj.get("users_url"),
            "teams_url": obj.get("teams_url"),
            "apps_url": obj.get("apps_url"),
            "users": [BranchRestrictionPolicyUsersInner.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "teams": [Team.from_dict(_item) for _item in obj["teams"]] if obj.get("teams") is not None else None,
            "apps": [BranchRestrictionPolicyAppsInner.from_dict(_item) for _item in obj["apps"]] if obj.get("apps") is not None else None
        })
        return _obj


