# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.branch_restriction_policy_apps_inner_owner import BranchRestrictionPolicyAppsInnerOwner
from devopso.clients.github.models.branch_restriction_policy_apps_inner_permissions import BranchRestrictionPolicyAppsInnerPermissions
from typing import Optional, Set
from typing_extensions import Self

class BranchRestrictionPolicyAppsInner(BaseModel):
    """
    BranchRestrictionPolicyAppsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    slug: Optional[StrictStr] = None
    node_id: Optional[StrictStr] = None
    owner: Optional[BranchRestrictionPolicyAppsInnerOwner] = None
    name: Optional[StrictStr] = None
    client_id: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    external_url: Optional[StrictStr] = None
    html_url: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    permissions: Optional[BranchRestrictionPolicyAppsInnerPermissions] = None
    events: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["id", "slug", "node_id", "owner", "name", "client_id", "description", "external_url", "html_url", "created_at", "updated_at", "permissions", "events"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BranchRestrictionPolicyAppsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BranchRestrictionPolicyAppsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "slug": obj.get("slug"),
            "node_id": obj.get("node_id"),
            "owner": BranchRestrictionPolicyAppsInnerOwner.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "name": obj.get("name"),
            "client_id": obj.get("client_id"),
            "description": obj.get("description"),
            "external_url": obj.get("external_url"),
            "html_url": obj.get("html_url"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "permissions": BranchRestrictionPolicyAppsInnerPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "events": obj.get("events")
        })
        return _obj


