# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.branch_protection import BranchProtection
from devopso.clients.github.models.branch_with_protection_links import BranchWithProtectionLinks
from devopso.clients.github.models.commit import Commit
from typing import Optional, Set
from typing_extensions import Self

class BranchWithProtection(BaseModel):
    """
    Branch With Protection
    """ # noqa: E501
    name: StrictStr
    commit: Commit
    links: BranchWithProtectionLinks = Field(alias="_links")
    protected: StrictBool
    protection: BranchProtection
    protection_url: StrictStr
    pattern: Optional[StrictStr] = None
    required_approving_review_count: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["name", "commit", "_links", "protected", "protection", "protection_url", "pattern", "required_approving_review_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BranchWithProtection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of commit
        if self.commit:
            _dict['commit'] = self.commit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        # override the default output from pydantic by calling `to_dict()` of protection
        if self.protection:
            _dict['protection'] = self.protection.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BranchWithProtection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "commit": Commit.from_dict(obj["commit"]) if obj.get("commit") is not None else None,
            "_links": BranchWithProtectionLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None,
            "protected": obj.get("protected"),
            "protection": BranchProtection.from_dict(obj["protection"]) if obj.get("protection") is not None else None,
            "protection_url": obj.get("protection_url"),
            "pattern": obj.get("pattern"),
            "required_approving_review_count": obj.get("required_approving_review_count")
        })
        return _obj


