# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.campaign_state import CampaignState
from devopso.clients.github.models.campaign_summary_alert_stats import CampaignSummaryAlertStats
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.team import Team
from typing import Optional, Set
from typing_extensions import Self

class CampaignSummary(BaseModel):
    """
    The campaign metadata and alert stats.
    """ # noqa: E501
    number: StrictInt = Field(description="The number of the newly created campaign")
    created_at: datetime = Field(description="The date and time the campaign was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.")
    updated_at: datetime = Field(description="The date and time the campaign was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.")
    name: Optional[StrictStr] = Field(default=None, description="The campaign name")
    description: StrictStr = Field(description="The campaign description")
    managers: List[SimpleUser] = Field(description="The campaign managers")
    team_managers: Optional[List[Team]] = Field(default=None, description="The campaign team managers")
    published_at: Optional[datetime] = Field(default=None, description="The date and time the campaign was published, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.")
    ends_at: datetime = Field(description="The date and time the campaign has ended, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.")
    closed_at: Optional[datetime] = Field(default=None, description="The date and time the campaign was closed, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ. Will be null if the campaign is still open.")
    state: CampaignState
    contact_link: Optional[StrictStr] = Field(description="The contact link of the campaign.")
    alert_stats: Optional[CampaignSummaryAlertStats] = None
    __properties: ClassVar[List[str]] = ["number", "created_at", "updated_at", "name", "description", "managers", "team_managers", "published_at", "ends_at", "closed_at", "state", "contact_link", "alert_stats"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CampaignSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in managers (list)
        _items = []
        if self.managers:
            for _item_managers in self.managers:
                if _item_managers:
                    _items.append(_item_managers.to_dict())
            _dict['managers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in team_managers (list)
        _items = []
        if self.team_managers:
            for _item_team_managers in self.team_managers:
                if _item_team_managers:
                    _items.append(_item_team_managers.to_dict())
            _dict['team_managers'] = _items
        # override the default output from pydantic by calling `to_dict()` of alert_stats
        if self.alert_stats:
            _dict['alert_stats'] = self.alert_stats.to_dict()
        # set to None if closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.closed_at is None and "closed_at" in self.model_fields_set:
            _dict['closed_at'] = None

        # set to None if contact_link (nullable) is None
        # and model_fields_set contains the field
        if self.contact_link is None and "contact_link" in self.model_fields_set:
            _dict['contact_link'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CampaignSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "number": obj.get("number"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "managers": [SimpleUser.from_dict(_item) for _item in obj["managers"]] if obj.get("managers") is not None else None,
            "team_managers": [Team.from_dict(_item) for _item in obj["team_managers"]] if obj.get("team_managers") is not None else None,
            "published_at": obj.get("published_at"),
            "ends_at": obj.get("ends_at"),
            "closed_at": obj.get("closed_at"),
            "state": obj.get("state"),
            "contact_link": obj.get("contact_link"),
            "alert_stats": CampaignSummaryAlertStats.from_dict(obj["alert_stats"]) if obj.get("alert_stats") is not None else None
        })
        return _obj


