# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.campaigns_create_campaign_request_code_scanning_alerts_inner import CampaignsCreateCampaignRequestCodeScanningAlertsInner
from typing import Optional, Set
from typing_extensions import Self

class CampaignsCreateCampaignRequest(BaseModel):
    """
    CampaignsCreateCampaignRequest
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="The name of the campaign")
    description: Annotated[str, Field(min_length=1, strict=True, max_length=255)] = Field(description="A description for the campaign")
    managers: Optional[Annotated[List[StrictStr], Field(max_length=10)]] = Field(default=None, description="The logins of the users to set as the campaign managers. At this time, only a single manager can be supplied.")
    team_managers: Optional[Annotated[List[StrictStr], Field(max_length=10)]] = Field(default=None, description="The slugs of the teams to set as the campaign managers.")
    ends_at: datetime = Field(description="The end date and time of the campaign. The date must be in the future.")
    contact_link: Optional[StrictStr] = Field(default=None, description="The contact link of the campaign. Must be a URI.")
    code_scanning_alerts: Annotated[List[CampaignsCreateCampaignRequestCodeScanningAlertsInner], Field(min_length=1)] = Field(description="The code scanning alerts to include in this campaign")
    generate_issues: Optional[StrictBool] = Field(default=False, description="If true, will automatically generate issues for the campaign. The default is false.")
    __properties: ClassVar[List[str]] = ["name", "description", "managers", "team_managers", "ends_at", "contact_link", "code_scanning_alerts", "generate_issues"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CampaignsCreateCampaignRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in code_scanning_alerts (list)
        _items = []
        if self.code_scanning_alerts:
            for _item_code_scanning_alerts in self.code_scanning_alerts:
                if _item_code_scanning_alerts:
                    _items.append(_item_code_scanning_alerts.to_dict())
            _dict['code_scanning_alerts'] = _items
        # set to None if contact_link (nullable) is None
        # and model_fields_set contains the field
        if self.contact_link is None and "contact_link" in self.model_fields_set:
            _dict['contact_link'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CampaignsCreateCampaignRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "managers": obj.get("managers"),
            "team_managers": obj.get("team_managers"),
            "ends_at": obj.get("ends_at"),
            "contact_link": obj.get("contact_link"),
            "code_scanning_alerts": [CampaignsCreateCampaignRequestCodeScanningAlertsInner.from_dict(_item) for _item in obj["code_scanning_alerts"]] if obj.get("code_scanning_alerts") is not None else None,
            "generate_issues": obj.get("generate_issues") if obj.get("generate_issues") is not None else False
        })
        return _obj


