# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CheckAnnotation(BaseModel):
    """
    Check Annotation
    """ # noqa: E501
    path: StrictStr
    start_line: StrictInt
    end_line: StrictInt
    start_column: Optional[StrictInt]
    end_column: Optional[StrictInt]
    annotation_level: Optional[StrictStr]
    title: Optional[StrictStr]
    message: Optional[StrictStr]
    raw_details: Optional[StrictStr]
    blob_href: StrictStr
    __properties: ClassVar[List[str]] = ["path", "start_line", "end_line", "start_column", "end_column", "annotation_level", "title", "message", "raw_details", "blob_href"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CheckAnnotation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if start_column (nullable) is None
        # and model_fields_set contains the field
        if self.start_column is None and "start_column" in self.model_fields_set:
            _dict['start_column'] = None

        # set to None if end_column (nullable) is None
        # and model_fields_set contains the field
        if self.end_column is None and "end_column" in self.model_fields_set:
            _dict['end_column'] = None

        # set to None if annotation_level (nullable) is None
        # and model_fields_set contains the field
        if self.annotation_level is None and "annotation_level" in self.model_fields_set:
            _dict['annotation_level'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if message (nullable) is None
        # and model_fields_set contains the field
        if self.message is None and "message" in self.model_fields_set:
            _dict['message'] = None

        # set to None if raw_details (nullable) is None
        # and model_fields_set contains the field
        if self.raw_details is None and "raw_details" in self.model_fields_set:
            _dict['raw_details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CheckAnnotation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "path": obj.get("path"),
            "start_line": obj.get("start_line"),
            "end_line": obj.get("end_line"),
            "start_column": obj.get("start_column"),
            "end_column": obj.get("end_column"),
            "annotation_level": obj.get("annotation_level"),
            "title": obj.get("title"),
            "message": obj.get("message"),
            "raw_details": obj.get("raw_details"),
            "blob_href": obj.get("blob_href")
        })
        return _obj


