# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.check_run_check_suite import CheckRunCheckSuite
from devopso.clients.github.models.check_run_output import CheckRunOutput
from devopso.clients.github.models.deployment_simple import DeploymentSimple
from devopso.clients.github.models.nullable_integration import NullableIntegration
from devopso.clients.github.models.pull_request_minimal import PullRequestMinimal
from typing import Optional, Set
from typing_extensions import Self

class CheckRun(BaseModel):
    """
    A check performed on the code of a given code change
    """ # noqa: E501
    id: StrictInt = Field(description="The id of the check.")
    head_sha: StrictStr = Field(description="The SHA of the commit that is being checked.")
    node_id: StrictStr
    external_id: Optional[StrictStr]
    url: StrictStr
    html_url: Optional[StrictStr]
    details_url: Optional[StrictStr]
    status: StrictStr = Field(description="The phase of the lifecycle that the check is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check runs.")
    conclusion: Optional[StrictStr]
    started_at: Optional[datetime]
    completed_at: Optional[datetime]
    output: CheckRunOutput
    name: StrictStr = Field(description="The name of the check.")
    check_suite: Optional[CheckRunCheckSuite]
    app: Optional[NullableIntegration]
    pull_requests: List[PullRequestMinimal] = Field(description="Pull requests that are open with a `head_sha` or `head_branch` that matches the check. The returned pull requests do not necessarily indicate pull requests that triggered the check.")
    deployment: Optional[DeploymentSimple] = None
    __properties: ClassVar[List[str]] = ["id", "head_sha", "node_id", "external_id", "url", "html_url", "details_url", "status", "conclusion", "started_at", "completed_at", "output", "name", "check_suite", "app", "pull_requests", "deployment"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['queued', 'in_progress', 'completed', 'waiting', 'requested', 'pending']):
            raise ValueError("must be one of enum values ('queued', 'in_progress', 'completed', 'waiting', 'requested', 'pending')")
        return value

    @field_validator('conclusion')
    def conclusion_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['success', 'failure', 'neutral', 'cancelled', 'skipped', 'timed_out', 'action_required']):
            raise ValueError("must be one of enum values ('success', 'failure', 'neutral', 'cancelled', 'skipped', 'timed_out', 'action_required')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CheckRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of output
        if self.output:
            _dict['output'] = self.output.to_dict()
        # override the default output from pydantic by calling `to_dict()` of check_suite
        if self.check_suite:
            _dict['check_suite'] = self.check_suite.to_dict()
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['app'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in pull_requests (list)
        _items = []
        if self.pull_requests:
            for _item_pull_requests in self.pull_requests:
                if _item_pull_requests:
                    _items.append(_item_pull_requests.to_dict())
            _dict['pull_requests'] = _items
        # override the default output from pydantic by calling `to_dict()` of deployment
        if self.deployment:
            _dict['deployment'] = self.deployment.to_dict()
        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['external_id'] = None

        # set to None if html_url (nullable) is None
        # and model_fields_set contains the field
        if self.html_url is None and "html_url" in self.model_fields_set:
            _dict['html_url'] = None

        # set to None if details_url (nullable) is None
        # and model_fields_set contains the field
        if self.details_url is None and "details_url" in self.model_fields_set:
            _dict['details_url'] = None

        # set to None if conclusion (nullable) is None
        # and model_fields_set contains the field
        if self.conclusion is None and "conclusion" in self.model_fields_set:
            _dict['conclusion'] = None

        # set to None if started_at (nullable) is None
        # and model_fields_set contains the field
        if self.started_at is None and "started_at" in self.model_fields_set:
            _dict['started_at'] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completed_at'] = None

        # set to None if check_suite (nullable) is None
        # and model_fields_set contains the field
        if self.check_suite is None and "check_suite" in self.model_fields_set:
            _dict['check_suite'] = None

        # set to None if app (nullable) is None
        # and model_fields_set contains the field
        if self.app is None and "app" in self.model_fields_set:
            _dict['app'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CheckRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "head_sha": obj.get("head_sha"),
            "node_id": obj.get("node_id"),
            "external_id": obj.get("external_id"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "details_url": obj.get("details_url"),
            "status": obj.get("status"),
            "conclusion": obj.get("conclusion"),
            "started_at": obj.get("started_at"),
            "completed_at": obj.get("completed_at"),
            "output": CheckRunOutput.from_dict(obj["output"]) if obj.get("output") is not None else None,
            "name": obj.get("name"),
            "check_suite": CheckRunCheckSuite.from_dict(obj["check_suite"]) if obj.get("check_suite") is not None else None,
            "app": NullableIntegration.from_dict(obj["app"]) if obj.get("app") is not None else None,
            "pull_requests": [PullRequestMinimal.from_dict(_item) for _item in obj["pull_requests"]] if obj.get("pull_requests") is not None else None,
            "deployment": DeploymentSimple.from_dict(obj["deployment"]) if obj.get("deployment") is not None else None
        })
        return _obj


