# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.check_run_with_simple_check_suite_output import CheckRunWithSimpleCheckSuiteOutput
from devopso.clients.github.models.deployment_simple import DeploymentSimple
from devopso.clients.github.models.integration import Integration
from devopso.clients.github.models.pull_request_minimal import PullRequestMinimal
from devopso.clients.github.models.simple_check_suite import SimpleCheckSuite
from typing import Optional, Set
from typing_extensions import Self

class CheckRunWithSimpleCheckSuite(BaseModel):
    """
    A check performed on the code of a given code change
    """ # noqa: E501
    app: Optional[Integration]
    check_suite: SimpleCheckSuite
    completed_at: Optional[datetime]
    conclusion: Optional[StrictStr]
    deployment: Optional[DeploymentSimple] = None
    details_url: StrictStr
    external_id: StrictStr
    head_sha: StrictStr = Field(description="The SHA of the commit that is being checked.")
    html_url: StrictStr
    id: StrictInt = Field(description="The id of the check.")
    name: StrictStr = Field(description="The name of the check.")
    node_id: StrictStr
    output: CheckRunWithSimpleCheckSuiteOutput
    pull_requests: List[PullRequestMinimal]
    started_at: datetime
    status: StrictStr = Field(description="The phase of the lifecycle that the check is currently in.")
    url: StrictStr
    __properties: ClassVar[List[str]] = ["app", "check_suite", "completed_at", "conclusion", "deployment", "details_url", "external_id", "head_sha", "html_url", "id", "name", "node_id", "output", "pull_requests", "started_at", "status", "url"]

    @field_validator('conclusion')
    def conclusion_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['waiting', 'pending', 'startup_failure', 'stale', 'success', 'failure', 'neutral', 'cancelled', 'skipped', 'timed_out', 'action_required']):
            raise ValueError("must be one of enum values ('waiting', 'pending', 'startup_failure', 'stale', 'success', 'failure', 'neutral', 'cancelled', 'skipped', 'timed_out', 'action_required')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['queued', 'in_progress', 'completed', 'pending']):
            raise ValueError("must be one of enum values ('queued', 'in_progress', 'completed', 'pending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CheckRunWithSimpleCheckSuite from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['app'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of check_suite
        if self.check_suite:
            _dict['check_suite'] = self.check_suite.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deployment
        if self.deployment:
            _dict['deployment'] = self.deployment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of output
        if self.output:
            _dict['output'] = self.output.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in pull_requests (list)
        _items = []
        if self.pull_requests:
            for _item_pull_requests in self.pull_requests:
                if _item_pull_requests:
                    _items.append(_item_pull_requests.to_dict())
            _dict['pull_requests'] = _items
        # set to None if app (nullable) is None
        # and model_fields_set contains the field
        if self.app is None and "app" in self.model_fields_set:
            _dict['app'] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completed_at'] = None

        # set to None if conclusion (nullable) is None
        # and model_fields_set contains the field
        if self.conclusion is None and "conclusion" in self.model_fields_set:
            _dict['conclusion'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CheckRunWithSimpleCheckSuite from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "app": Integration.from_dict(obj["app"]) if obj.get("app") is not None else None,
            "check_suite": SimpleCheckSuite.from_dict(obj["check_suite"]) if obj.get("check_suite") is not None else None,
            "completed_at": obj.get("completed_at"),
            "conclusion": obj.get("conclusion"),
            "deployment": DeploymentSimple.from_dict(obj["deployment"]) if obj.get("deployment") is not None else None,
            "details_url": obj.get("details_url"),
            "external_id": obj.get("external_id"),
            "head_sha": obj.get("head_sha"),
            "html_url": obj.get("html_url"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "node_id": obj.get("node_id"),
            "output": CheckRunWithSimpleCheckSuiteOutput.from_dict(obj["output"]) if obj.get("output") is not None else None,
            "pull_requests": [PullRequestMinimal.from_dict(_item) for _item in obj["pull_requests"]] if obj.get("pull_requests") is not None else None,
            "started_at": obj.get("started_at"),
            "status": obj.get("status"),
            "url": obj.get("url")
        })
        return _obj


